/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.DataIdentifierSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SeverityLevel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SeverityLevel> {
    private static final SdkField<Long> OCCURRENCES_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("occurrencesThreshold").getter(SeverityLevel.getter(SeverityLevel::occurrencesThreshold)).setter(SeverityLevel.setter(Builder::occurrencesThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("occurrencesThreshold").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(SeverityLevel.getter(SeverityLevel::severityAsString)).setter(SeverityLevel.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OCCURRENCES_THRESHOLD_FIELD, SEVERITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long occurrencesThreshold;
    private final String severity;

    private SeverityLevel(BuilderImpl builder) {
        this.occurrencesThreshold = builder.occurrencesThreshold;
        this.severity = builder.severity;
    }

    public final Long occurrencesThreshold() {
        return this.occurrencesThreshold;
    }

    public final DataIdentifierSeverity severity() {
        return DataIdentifierSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrencesThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityLevel)) {
            return false;
        }
        SeverityLevel other = (SeverityLevel)obj;
        return Objects.equals(this.occurrencesThreshold(), other.occurrencesThreshold()) && Objects.equals(this.severityAsString(), other.severityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SeverityLevel").add("OccurrencesThreshold", (Object)this.occurrencesThreshold()).add("Severity", (Object)this.severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "occurrencesThreshold": {
                return Optional.ofNullable(clazz.cast(this.occurrencesThreshold()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeverityLevel, T> g) {
        return obj -> g.apply((SeverityLevel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long occurrencesThreshold;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityLevel model) {
            this.occurrencesThreshold(model.occurrencesThreshold);
            this.severity(model.severity);
        }

        public final Long getOccurrencesThreshold() {
            return this.occurrencesThreshold;
        }

        public final void setOccurrencesThreshold(Long occurrencesThreshold) {
            this.occurrencesThreshold = occurrencesThreshold;
        }

        @Override
        @Transient
        public final Builder occurrencesThreshold(Long occurrencesThreshold) {
            this.occurrencesThreshold = occurrencesThreshold;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        @Transient
        public final Builder severity(DataIdentifierSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public SeverityLevel build() {
            return new SeverityLevel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SeverityLevel> {
        public Builder occurrencesThreshold(Long var1);

        public Builder severity(String var1);

        public Builder severity(DataIdentifierSeverity var1);
    }
}

