/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCustomDataIdentifierRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, TestCustomDataIdentifierRequest> {
    private static final SdkField<List<String>> IGNORE_WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ignoreWords").getter(TestCustomDataIdentifierRequest.getter(TestCustomDataIdentifierRequest::ignoreWords)).setter(TestCustomDataIdentifierRequest.setter(Builder::ignoreWords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreWords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keywords").getter(TestCustomDataIdentifierRequest.getter(TestCustomDataIdentifierRequest::keywords)).setter(TestCustomDataIdentifierRequest.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_MATCH_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMatchDistance").getter(TestCustomDataIdentifierRequest.getter(TestCustomDataIdentifierRequest::maximumMatchDistance)).setter(TestCustomDataIdentifierRequest.setter(Builder::maximumMatchDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMatchDistance").build()}).build();
    private static final SdkField<String> REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regex").getter(TestCustomDataIdentifierRequest.getter(TestCustomDataIdentifierRequest::regex)).setter(TestCustomDataIdentifierRequest.setter(Builder::regex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()}).build();
    private static final SdkField<String> SAMPLE_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleText").getter(TestCustomDataIdentifierRequest.getter(TestCustomDataIdentifierRequest::sampleText)).setter(TestCustomDataIdentifierRequest.setter(Builder::sampleText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IGNORE_WORDS_FIELD, KEYWORDS_FIELD, MAXIMUM_MATCH_DISTANCE_FIELD, REGEX_FIELD, SAMPLE_TEXT_FIELD));
    private final List<String> ignoreWords;
    private final List<String> keywords;
    private final Integer maximumMatchDistance;
    private final String regex;
    private final String sampleText;

    private TestCustomDataIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.ignoreWords = builder.ignoreWords;
        this.keywords = builder.keywords;
        this.maximumMatchDistance = builder.maximumMatchDistance;
        this.regex = builder.regex;
        this.sampleText = builder.sampleText;
    }

    public final boolean hasIgnoreWords() {
        return this.ignoreWords != null && !(this.ignoreWords instanceof SdkAutoConstructList);
    }

    public final List<String> ignoreWords() {
        return this.ignoreWords;
    }

    public final boolean hasKeywords() {
        return this.keywords != null && !(this.keywords instanceof SdkAutoConstructList);
    }

    public final List<String> keywords() {
        return this.keywords;
    }

    public final Integer maximumMatchDistance() {
        return this.maximumMatchDistance;
    }

    public final String regex() {
        return this.regex;
    }

    public final String sampleText() {
        return this.sampleText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIgnoreWords() ? this.ignoreWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeywords() ? this.keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMatchDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.regex());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCustomDataIdentifierRequest)) {
            return false;
        }
        TestCustomDataIdentifierRequest other = (TestCustomDataIdentifierRequest)((Object)obj);
        return this.hasIgnoreWords() == other.hasIgnoreWords() && Objects.equals(this.ignoreWords(), other.ignoreWords()) && this.hasKeywords() == other.hasKeywords() && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.maximumMatchDistance(), other.maximumMatchDistance()) && Objects.equals(this.regex(), other.regex()) && Objects.equals(this.sampleText(), other.sampleText());
    }

    public final String toString() {
        return ToString.builder((String)"TestCustomDataIdentifierRequest").add("IgnoreWords", this.hasIgnoreWords() ? this.ignoreWords() : null).add("Keywords", this.hasKeywords() ? this.keywords() : null).add("MaximumMatchDistance", (Object)this.maximumMatchDistance()).add("Regex", (Object)this.regex()).add("SampleText", (Object)this.sampleText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ignoreWords": {
                return Optional.ofNullable(clazz.cast(this.ignoreWords()));
            }
            case "keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "maximumMatchDistance": {
                return Optional.ofNullable(clazz.cast(this.maximumMatchDistance()));
            }
            case "regex": {
                return Optional.ofNullable(clazz.cast(this.regex()));
            }
            case "sampleText": {
                return Optional.ofNullable(clazz.cast(this.sampleText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCustomDataIdentifierRequest, T> g) {
        return obj -> g.apply((TestCustomDataIdentifierRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private List<String> ignoreWords = DefaultSdkAutoConstructList.getInstance();
        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumMatchDistance;
        private String regex;
        private String sampleText;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCustomDataIdentifierRequest model) {
            super(model);
            this.ignoreWords(model.ignoreWords);
            this.keywords(model.keywords);
            this.maximumMatchDistance(model.maximumMatchDistance);
            this.regex(model.regex);
            this.sampleText(model.sampleText);
        }

        public final Collection<String> getIgnoreWords() {
            if (this.ignoreWords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ignoreWords;
        }

        @Override
        public final Builder ignoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoreWords(String ... ignoreWords) {
            this.ignoreWords(Arrays.asList(ignoreWords));
            return this;
        }

        public final void setIgnoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
        }

        public final Collection<String> getKeywords() {
            if (this.keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keywords;
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String ... keywords) {
            this.keywords(Arrays.asList(keywords));
            return this;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
        }

        public final Integer getMaximumMatchDistance() {
            return this.maximumMatchDistance;
        }

        @Override
        public final Builder maximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        public final void setMaximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
        }

        public final String getRegex() {
            return this.regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        public final String getSampleText() {
            return this.sampleText;
        }

        @Override
        public final Builder sampleText(String sampleText) {
            this.sampleText = sampleText;
            return this;
        }

        public final void setSampleText(String sampleText) {
            this.sampleText = sampleText;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestCustomDataIdentifierRequest build() {
            return new TestCustomDataIdentifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestCustomDataIdentifierRequest> {
        public Builder ignoreWords(Collection<String> var1);

        public Builder ignoreWords(String ... var1);

        public Builder keywords(Collection<String> var1);

        public Builder keywords(String ... var1);

        public Builder maximumMatchDistance(Integer var1);

        public Builder regex(String var1);

        public Builder sampleText(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

