/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cell
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cell> {
    private static final SdkField<String> CELL_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cellReference").getter(Cell.getter(Cell::cellReference)).setter(Cell.setter(Builder::cellReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellReference").build()}).build();
    private static final SdkField<Long> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("column").getter(Cell.getter(Cell::column)).setter(Cell.setter(Builder::column)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("column").build()}).build();
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("columnName").getter(Cell.getter(Cell::columnName)).setter(Cell.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()}).build();
    private static final SdkField<Long> ROW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("row").getter(Cell.getter(Cell::row)).setter(Cell.setter(Builder::row)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("row").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_REFERENCE_FIELD, COLUMN_FIELD, COLUMN_NAME_FIELD, ROW_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cellReference;
    private final Long column;
    private final String columnName;
    private final Long row;

    private Cell(BuilderImpl builder) {
        this.cellReference = builder.cellReference;
        this.column = builder.column;
        this.columnName = builder.columnName;
        this.row = builder.row;
    }

    public final String cellReference() {
        return this.cellReference;
    }

    public final Long column() {
        return this.column;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final Long row() {
        return this.row;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cellReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.row());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)obj;
        return Objects.equals(this.cellReference(), other.cellReference()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.row(), other.row());
    }

    public final String toString() {
        return ToString.builder((String)"Cell").add("CellReference", (Object)this.cellReference()).add("Column", (Object)this.column()).add("ColumnName", (Object)this.columnName()).add("Row", (Object)this.row()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cellReference": {
                return Optional.ofNullable(clazz.cast(this.cellReference()));
            }
            case "column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "columnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "row": {
                return Optional.ofNullable(clazz.cast(this.row()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cell, T> g) {
        return obj -> g.apply((Cell)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cellReference;
        private Long column;
        private String columnName;
        private Long row;

        private BuilderImpl() {
        }

        private BuilderImpl(Cell model) {
            this.cellReference(model.cellReference);
            this.column(model.column);
            this.columnName(model.columnName);
            this.row(model.row);
        }

        public final String getCellReference() {
            return this.cellReference;
        }

        @Override
        public final Builder cellReference(String cellReference) {
            this.cellReference = cellReference;
            return this;
        }

        public final void setCellReference(String cellReference) {
            this.cellReference = cellReference;
        }

        public final Long getColumn() {
            return this.column;
        }

        @Override
        public final Builder column(Long column) {
            this.column = column;
            return this;
        }

        public final void setColumn(Long column) {
            this.column = column;
        }

        public final String getColumnName() {
            return this.columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final Long getRow() {
            return this.row;
        }

        @Override
        public final Builder row(Long row) {
            this.row = row;
            return this;
        }

        public final void setRow(Long row) {
            this.row = row;
        }

        public Cell build() {
            return new Cell(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cell> {
        public Builder cellReference(String var1);

        public Builder column(Long var1);

        public Builder columnName(String var1);

        public Builder row(Long var1);
    }
}

