/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.JobScopingBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scoping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Scoping> {
    private static final SdkField<JobScopingBlock> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("excludes").getter(Scoping.getter(Scoping::excludes)).setter(Scoping.setter(Builder::excludes)).constructor(JobScopingBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()}).build();
    private static final SdkField<JobScopingBlock> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("includes").getter(Scoping.getter(Scoping::includes)).setter(Scoping.setter(Builder::includes)).constructor(JobScopingBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDES_FIELD, INCLUDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final JobScopingBlock excludes;
    private final JobScopingBlock includes;

    private Scoping(BuilderImpl builder) {
        this.excludes = builder.excludes;
        this.includes = builder.includes;
    }

    public JobScopingBlock excludes() {
        return this.excludes;
    }

    public JobScopingBlock includes() {
        return this.includes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.excludes());
        hashCode = 31 * hashCode + Objects.hashCode(this.includes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scoping)) {
            return false;
        }
        Scoping other = (Scoping)obj;
        return Objects.equals(this.excludes(), other.excludes()) && Objects.equals(this.includes(), other.includes());
    }

    public String toString() {
        return ToString.builder((String)"Scoping").add("Excludes", (Object)this.excludes()).add("Includes", (Object)this.includes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scoping, T> g) {
        return obj -> g.apply((Scoping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JobScopingBlock excludes;
        private JobScopingBlock includes;

        private BuilderImpl() {
        }

        private BuilderImpl(Scoping model) {
            this.excludes(model.excludes);
            this.includes(model.includes);
        }

        public final JobScopingBlock.Builder getExcludes() {
            return this.excludes != null ? this.excludes.toBuilder() : null;
        }

        @Override
        public final Builder excludes(JobScopingBlock excludes) {
            this.excludes = excludes;
            return this;
        }

        public final void setExcludes(JobScopingBlock.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        public final JobScopingBlock.Builder getIncludes() {
            return this.includes != null ? this.includes.toBuilder() : null;
        }

        @Override
        public final Builder includes(JobScopingBlock includes) {
            this.includes = includes;
            return this;
        }

        public final void setIncludes(JobScopingBlock.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        public Scoping build() {
            return new Scoping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Scoping> {
        public Builder excludes(JobScopingBlock var1);

        default public Builder excludes(Consumer<JobScopingBlock.Builder> excludes) {
            return this.excludes((JobScopingBlock)((JobScopingBlock.Builder)JobScopingBlock.builder().applyMutation(excludes)).build());
        }

        public Builder includes(JobScopingBlock var1);

        default public Builder includes(Consumer<JobScopingBlock.Builder> includes) {
            return this.includes((JobScopingBlock)((JobScopingBlock.Builder)JobScopingBlock.builder().applyMutation(includes)).build());
        }
    }
}

