/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.ClassificationResultStatus;
import software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers;
import software.amazon.awssdk.services.macie2.model.SensitiveDataCopier;
import software.amazon.awssdk.services.macie2.model.SensitiveDataItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassificationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClassificationResult> {
    private static final SdkField<Boolean> ADDITIONAL_OCCURRENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("additionalOccurrences").getter(ClassificationResult.getter(ClassificationResult::additionalOccurrences)).setter(ClassificationResult.setter(Builder::additionalOccurrences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalOccurrences").build()}).build();
    private static final SdkField<CustomDataIdentifiers> CUSTOM_DATA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customDataIdentifiers").getter(ClassificationResult.getter(ClassificationResult::customDataIdentifiers)).setter(ClassificationResult.setter(Builder::customDataIdentifiers)).constructor(CustomDataIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifiers").build()}).build();
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mimeType").getter(ClassificationResult.getter(ClassificationResult::mimeType)).setter(ClassificationResult.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()}).build();
    private static final SdkField<List<SensitiveDataItem>> SENSITIVE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sensitiveData").getter(ClassificationResult.getter(ClassificationResult::sensitiveData)).setter(ClassificationResult.setter(Builder::sensitiveData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SensitiveDataItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> SIZE_CLASSIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("sizeClassified").getter(ClassificationResult.getter(ClassificationResult::sizeClassified)).setter(ClassificationResult.setter(Builder::sizeClassified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeClassified").build()}).build();
    private static final SdkField<ClassificationResultStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ClassificationResult.getter(ClassificationResult::status)).setter(ClassificationResult.setter(Builder::status)).constructor(ClassificationResultStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_OCCURRENCES_FIELD, CUSTOM_DATA_IDENTIFIERS_FIELD, MIME_TYPE_FIELD, SENSITIVE_DATA_FIELD, SIZE_CLASSIFIED_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean additionalOccurrences;
    private final CustomDataIdentifiers customDataIdentifiers;
    private final String mimeType;
    private final List<SensitiveDataItem> sensitiveData;
    private final Long sizeClassified;
    private final ClassificationResultStatus status;

    private ClassificationResult(BuilderImpl builder) {
        this.additionalOccurrences = builder.additionalOccurrences;
        this.customDataIdentifiers = builder.customDataIdentifiers;
        this.mimeType = builder.mimeType;
        this.sensitiveData = builder.sensitiveData;
        this.sizeClassified = builder.sizeClassified;
        this.status = builder.status;
    }

    public Boolean additionalOccurrences() {
        return this.additionalOccurrences;
    }

    public CustomDataIdentifiers customDataIdentifiers() {
        return this.customDataIdentifiers;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public boolean hasSensitiveData() {
        return this.sensitiveData != null && !(this.sensitiveData instanceof SdkAutoConstructList);
    }

    public List<SensitiveDataItem> sensitiveData() {
        return this.sensitiveData;
    }

    public Long sizeClassified() {
        return this.sizeClassified;
    }

    public ClassificationResultStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalOccurrences());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDataIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSensitiveData() ? this.sensitiveData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeClassified());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationResult)) {
            return false;
        }
        ClassificationResult other = (ClassificationResult)obj;
        return Objects.equals(this.additionalOccurrences(), other.additionalOccurrences()) && Objects.equals(this.customDataIdentifiers(), other.customDataIdentifiers()) && Objects.equals(this.mimeType(), other.mimeType()) && this.hasSensitiveData() == other.hasSensitiveData() && Objects.equals(this.sensitiveData(), other.sensitiveData()) && Objects.equals(this.sizeClassified(), other.sizeClassified()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ClassificationResult").add("AdditionalOccurrences", (Object)this.additionalOccurrences()).add("CustomDataIdentifiers", (Object)this.customDataIdentifiers()).add("MimeType", (Object)this.mimeType()).add("SensitiveData", this.hasSensitiveData() ? this.sensitiveData() : null).add("SizeClassified", (Object)this.sizeClassified()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalOccurrences": {
                return Optional.ofNullable(clazz.cast(this.additionalOccurrences()));
            }
            case "customDataIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.customDataIdentifiers()));
            }
            case "mimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeType()));
            }
            case "sensitiveData": {
                return Optional.ofNullable(clazz.cast(this.sensitiveData()));
            }
            case "sizeClassified": {
                return Optional.ofNullable(clazz.cast(this.sizeClassified()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationResult, T> g) {
        return obj -> g.apply((ClassificationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean additionalOccurrences;
        private CustomDataIdentifiers customDataIdentifiers;
        private String mimeType;
        private List<SensitiveDataItem> sensitiveData = DefaultSdkAutoConstructList.getInstance();
        private Long sizeClassified;
        private ClassificationResultStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationResult model) {
            this.additionalOccurrences(model.additionalOccurrences);
            this.customDataIdentifiers(model.customDataIdentifiers);
            this.mimeType(model.mimeType);
            this.sensitiveData(model.sensitiveData);
            this.sizeClassified(model.sizeClassified);
            this.status(model.status);
        }

        public final Boolean getAdditionalOccurrences() {
            return this.additionalOccurrences;
        }

        @Override
        public final Builder additionalOccurrences(Boolean additionalOccurrences) {
            this.additionalOccurrences = additionalOccurrences;
            return this;
        }

        public final void setAdditionalOccurrences(Boolean additionalOccurrences) {
            this.additionalOccurrences = additionalOccurrences;
        }

        public final CustomDataIdentifiers.Builder getCustomDataIdentifiers() {
            return this.customDataIdentifiers != null ? this.customDataIdentifiers.toBuilder() : null;
        }

        @Override
        public final Builder customDataIdentifiers(CustomDataIdentifiers customDataIdentifiers) {
            this.customDataIdentifiers = customDataIdentifiers;
            return this;
        }

        public final void setCustomDataIdentifiers(CustomDataIdentifiers.BuilderImpl customDataIdentifiers) {
            this.customDataIdentifiers = customDataIdentifiers != null ? customDataIdentifiers.build() : null;
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public final Collection<SensitiveDataItem.Builder> getSensitiveData() {
            if (this.sensitiveData instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sensitiveData != null ? (Collection)this.sensitiveData.stream().map(SensitiveDataItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sensitiveData(Collection<SensitiveDataItem> sensitiveData) {
            this.sensitiveData = SensitiveDataCopier.copy(sensitiveData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitiveData(SensitiveDataItem ... sensitiveData) {
            this.sensitiveData(Arrays.asList(sensitiveData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitiveData(Consumer<SensitiveDataItem.Builder> ... sensitiveData) {
            this.sensitiveData(Stream.of(sensitiveData).map(c -> (SensitiveDataItem)((SensitiveDataItem.Builder)SensitiveDataItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSensitiveData(Collection<SensitiveDataItem.BuilderImpl> sensitiveData) {
            this.sensitiveData = SensitiveDataCopier.copyFromBuilder(sensitiveData);
        }

        public final Long getSizeClassified() {
            return this.sizeClassified;
        }

        @Override
        public final Builder sizeClassified(Long sizeClassified) {
            this.sizeClassified = sizeClassified;
            return this;
        }

        public final void setSizeClassified(Long sizeClassified) {
            this.sizeClassified = sizeClassified;
        }

        public final ClassificationResultStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClassificationResultStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClassificationResultStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public ClassificationResult build() {
            return new ClassificationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClassificationResult> {
        public Builder additionalOccurrences(Boolean var1);

        public Builder customDataIdentifiers(CustomDataIdentifiers var1);

        default public Builder customDataIdentifiers(Consumer<CustomDataIdentifiers.Builder> customDataIdentifiers) {
            return this.customDataIdentifiers((CustomDataIdentifiers)((CustomDataIdentifiers.Builder)CustomDataIdentifiers.builder().applyMutation(customDataIdentifiers)).build());
        }

        public Builder mimeType(String var1);

        public Builder sensitiveData(Collection<SensitiveDataItem> var1);

        public Builder sensitiveData(SensitiveDataItem ... var1);

        public Builder sensitiveData(Consumer<SensitiveDataItem.Builder> ... var1);

        public Builder sizeClassified(Long var1);

        public Builder status(ClassificationResultStatus var1);

        default public Builder status(Consumer<ClassificationResultStatus.Builder> status) {
            return this.status((ClassificationResultStatus)((ClassificationResultStatus.Builder)ClassificationResultStatus.builder().applyMutation(status)).build());
        }
    }
}

