/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.CustomDetection;
import software.amazon.awssdk.services.macie2.model.CustomDetectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomDataIdentifiers
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomDataIdentifiers> {
    private static final SdkField<List<CustomDetection>> DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detections").getter(CustomDataIdentifiers.getter(CustomDataIdentifiers::detections)).setter(CustomDataIdentifiers.setter(Builder::detections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalCount").getter(CustomDataIdentifiers.getter(CustomDataIdentifiers::totalCount)).setter(CustomDataIdentifiers.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTIONS_FIELD, TOTAL_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CustomDetection> detections;
    private final Long totalCount;

    private CustomDataIdentifiers(BuilderImpl builder) {
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    public boolean hasDetections() {
        return this.detections != null && !(this.detections instanceof SdkAutoConstructList);
    }

    public List<CustomDetection> detections() {
        return this.detections;
    }

    public Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetections() ? this.detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDataIdentifiers)) {
            return false;
        }
        CustomDataIdentifiers other = (CustomDataIdentifiers)obj;
        return this.hasDetections() == other.hasDetections() && Objects.equals(this.detections(), other.detections()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"CustomDataIdentifiers").add("Detections", this.hasDetections() ? this.detections() : null).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detections": {
                return Optional.ofNullable(clazz.cast(this.detections()));
            }
            case "totalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDataIdentifiers, T> g) {
        return obj -> g.apply((CustomDataIdentifiers)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CustomDetection> detections = DefaultSdkAutoConstructList.getInstance();
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDataIdentifiers model) {
            this.detections(model.detections);
            this.totalCount(model.totalCount);
        }

        public final Collection<CustomDetection.Builder> getDetections() {
            if (this.detections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detections != null ? (Collection)this.detections.stream().map(CustomDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detections(Collection<CustomDetection> detections) {
            this.detections = CustomDetectionsCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(CustomDetection ... detections) {
            this.detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<CustomDetection.Builder> ... detections) {
            this.detections(Stream.of(detections).map(c -> (CustomDetection)((CustomDetection.Builder)CustomDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetections(Collection<CustomDetection.BuilderImpl> detections) {
            this.detections = CustomDetectionsCopier.copyFromBuilder(detections);
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public CustomDataIdentifiers build() {
            return new CustomDataIdentifiers(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomDataIdentifiers> {
        public Builder detections(Collection<CustomDetection> var1);

        public Builder detections(CustomDetection ... var1);

        public Builder detections(Consumer<CustomDetection.Builder> ... var1);

        public Builder totalCount(Long var1);
    }
}

