/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClassificationJobResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, CreateClassificationJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(CreateClassificationJobResponse.getter(CreateClassificationJobResponse::jobArn)).setter(CreateClassificationJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(CreateClassificationJobResponse.getter(CreateClassificationJobResponse::jobId)).setter(CreateClassificationJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_ID_FIELD));
    private final String jobArn;
    private final String jobId;

    private CreateClassificationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
    }

    public String jobArn() {
        return this.jobArn;
    }

    public String jobId() {
        return this.jobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClassificationJobResponse)) {
            return false;
        }
        CreateClassificationJobResponse other = (CreateClassificationJobResponse)((Object)obj);
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId());
    }

    public String toString() {
        return ToString.builder((String)"CreateClassificationJobResponse").add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClassificationJobResponse, T> g) {
        return obj -> g.apply((CreateClassificationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClassificationJobResponse model) {
            super(model);
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public CreateClassificationJobResponse build() {
            return new CreateClassificationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClassificationJobResponse> {
        public Builder jobArn(String var1);

        public Builder jobId(String var1);
    }
}

