/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.macie2.model.JobScheduleFrequency;
import software.amazon.awssdk.services.macie2.model.JobStatus;
import software.amazon.awssdk.services.macie2.model.JobType;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.S3JobDefinition;
import software.amazon.awssdk.services.macie2.model.Statistics;
import software.amazon.awssdk.services.macie2.model.TagMapCopier;
import software.amazon.awssdk.services.macie2.model.UserPausedDetails;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClassificationJobResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, DescribeClassificationJobResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::clientToken)).setter(DescribeClassificationJobResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::createdAt)).setter(DescribeClassificationJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> CUSTOM_DATA_IDENTIFIER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customDataIdentifierIds").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::customDataIdentifierIds)).setter(DescribeClassificationJobResponse.setter(Builder::customDataIdentifierIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifierIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::description)).setter(DescribeClassificationJobResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> INITIAL_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("initialRun").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::initialRun)).setter(DescribeClassificationJobResponse.setter(Builder::initialRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialRun").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::jobArn)).setter(DescribeClassificationJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::jobId)).setter(DescribeClassificationJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobStatus").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::jobStatusAsString)).setter(DescribeClassificationJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobType").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::jobTypeAsString)).setter(DescribeClassificationJobResponse.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<Instant> LAST_RUN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRunTime").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::lastRunTime)).setter(DescribeClassificationJobResponse.setter(Builder::lastRunTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::name)).setter(DescribeClassificationJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<S3JobDefinition> S3_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3JobDefinition").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::s3JobDefinition)).setter(DescribeClassificationJobResponse.setter(Builder::s3JobDefinition)).constructor(S3JobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3JobDefinition").build()}).build();
    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("samplingPercentage").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::samplingPercentage)).setter(DescribeClassificationJobResponse.setter(Builder::samplingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingPercentage").build()}).build();
    private static final SdkField<JobScheduleFrequency> SCHEDULE_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scheduleFrequency").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::scheduleFrequency)).setter(DescribeClassificationJobResponse.setter(Builder::scheduleFrequency)).constructor(JobScheduleFrequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleFrequency").build()}).build();
    private static final SdkField<Statistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::statistics)).setter(DescribeClassificationJobResponse.setter(Builder::statistics)).constructor(Statistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::tags)).setter(DescribeClassificationJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<UserPausedDetails> USER_PAUSED_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPausedDetails").getter(DescribeClassificationJobResponse.getter(DescribeClassificationJobResponse::userPausedDetails)).setter(DescribeClassificationJobResponse.setter(Builder::userPausedDetails)).constructor(UserPausedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPausedDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CREATED_AT_FIELD, CUSTOM_DATA_IDENTIFIER_IDS_FIELD, DESCRIPTION_FIELD, INITIAL_RUN_FIELD, JOB_ARN_FIELD, JOB_ID_FIELD, JOB_STATUS_FIELD, JOB_TYPE_FIELD, LAST_RUN_TIME_FIELD, NAME_FIELD, S3_JOB_DEFINITION_FIELD, SAMPLING_PERCENTAGE_FIELD, SCHEDULE_FREQUENCY_FIELD, STATISTICS_FIELD, TAGS_FIELD, USER_PAUSED_DETAILS_FIELD));
    private final String clientToken;
    private final Instant createdAt;
    private final List<String> customDataIdentifierIds;
    private final String description;
    private final Boolean initialRun;
    private final String jobArn;
    private final String jobId;
    private final String jobStatus;
    private final String jobType;
    private final Instant lastRunTime;
    private final String name;
    private final S3JobDefinition s3JobDefinition;
    private final Integer samplingPercentage;
    private final JobScheduleFrequency scheduleFrequency;
    private final Statistics statistics;
    private final Map<String, String> tags;
    private final UserPausedDetails userPausedDetails;

    private DescribeClassificationJobResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.createdAt = builder.createdAt;
        this.customDataIdentifierIds = builder.customDataIdentifierIds;
        this.description = builder.description;
        this.initialRun = builder.initialRun;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
        this.jobType = builder.jobType;
        this.lastRunTime = builder.lastRunTime;
        this.name = builder.name;
        this.s3JobDefinition = builder.s3JobDefinition;
        this.samplingPercentage = builder.samplingPercentage;
        this.scheduleFrequency = builder.scheduleFrequency;
        this.statistics = builder.statistics;
        this.tags = builder.tags;
        this.userPausedDetails = builder.userPausedDetails;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public boolean hasCustomDataIdentifierIds() {
        return this.customDataIdentifierIds != null && !(this.customDataIdentifierIds instanceof SdkAutoConstructList);
    }

    public List<String> customDataIdentifierIds() {
        return this.customDataIdentifierIds;
    }

    public String description() {
        return this.description;
    }

    public Boolean initialRun() {
        return this.initialRun;
    }

    public String jobArn() {
        return this.jobArn;
    }

    public String jobId() {
        return this.jobId;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeAsString() {
        return this.jobType;
    }

    public Instant lastRunTime() {
        return this.lastRunTime;
    }

    public String name() {
        return this.name;
    }

    public S3JobDefinition s3JobDefinition() {
        return this.s3JobDefinition;
    }

    public Integer samplingPercentage() {
        return this.samplingPercentage;
    }

    public JobScheduleFrequency scheduleFrequency() {
        return this.scheduleFrequency;
    }

    public Statistics statistics() {
        return this.statistics;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public UserPausedDetails userPausedDetails() {
        return this.userPausedDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDataIdentifierIds() ? this.customDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3JobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userPausedDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClassificationJobResponse)) {
            return false;
        }
        DescribeClassificationJobResponse other = (DescribeClassificationJobResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasCustomDataIdentifierIds() == other.hasCustomDataIdentifierIds() && Objects.equals(this.customDataIdentifierIds(), other.customDataIdentifierIds()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.initialRun(), other.initialRun()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.lastRunTime(), other.lastRunTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.s3JobDefinition(), other.s3JobDefinition()) && Objects.equals(this.samplingPercentage(), other.samplingPercentage()) && Objects.equals(this.scheduleFrequency(), other.scheduleFrequency()) && Objects.equals(this.statistics(), other.statistics()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.userPausedDetails(), other.userPausedDetails());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClassificationJobResponse").add("ClientToken", (Object)this.clientToken()).add("CreatedAt", (Object)this.createdAt()).add("CustomDataIdentifierIds", this.hasCustomDataIdentifierIds() ? this.customDataIdentifierIds() : null).add("Description", (Object)this.description()).add("InitialRun", (Object)this.initialRun()).add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).add("JobStatus", (Object)this.jobStatusAsString()).add("JobType", (Object)this.jobTypeAsString()).add("LastRunTime", (Object)this.lastRunTime()).add("Name", (Object)this.name()).add("S3JobDefinition", (Object)this.s3JobDefinition()).add("SamplingPercentage", (Object)this.samplingPercentage()).add("ScheduleFrequency", (Object)this.scheduleFrequency()).add("Statistics", (Object)this.statistics()).add("Tags", this.hasTags() ? this.tags() : null).add("UserPausedDetails", (Object)this.userPausedDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "customDataIdentifierIds": {
                return Optional.ofNullable(clazz.cast(this.customDataIdentifierIds()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "initialRun": {
                return Optional.ofNullable(clazz.cast(this.initialRun()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "lastRunTime": {
                return Optional.ofNullable(clazz.cast(this.lastRunTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "s3JobDefinition": {
                return Optional.ofNullable(clazz.cast(this.s3JobDefinition()));
            }
            case "samplingPercentage": {
                return Optional.ofNullable(clazz.cast(this.samplingPercentage()));
            }
            case "scheduleFrequency": {
                return Optional.ofNullable(clazz.cast(this.scheduleFrequency()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "userPausedDetails": {
                return Optional.ofNullable(clazz.cast(this.userPausedDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClassificationJobResponse, T> g) {
        return obj -> g.apply((DescribeClassificationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant createdAt;
        private List<String> customDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Boolean initialRun;
        private String jobArn;
        private String jobId;
        private String jobStatus;
        private String jobType;
        private Instant lastRunTime;
        private String name;
        private S3JobDefinition s3JobDefinition;
        private Integer samplingPercentage;
        private JobScheduleFrequency scheduleFrequency;
        private Statistics statistics;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private UserPausedDetails userPausedDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClassificationJobResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.createdAt(model.createdAt);
            this.customDataIdentifierIds(model.customDataIdentifierIds);
            this.description(model.description);
            this.initialRun(model.initialRun);
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
            this.jobStatus(model.jobStatus);
            this.jobType(model.jobType);
            this.lastRunTime(model.lastRunTime);
            this.name(model.name);
            this.s3JobDefinition(model.s3JobDefinition);
            this.samplingPercentage(model.samplingPercentage);
            this.scheduleFrequency(model.scheduleFrequency);
            this.statistics(model.statistics);
            this.tags(model.tags);
            this.userPausedDetails(model.userPausedDetails);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<String> getCustomDataIdentifierIds() {
            if (this.customDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customDataIdentifierIds;
        }

        @Override
        public final Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDataIdentifierIds(String ... customDataIdentifierIds) {
            this.customDataIdentifierIds(Arrays.asList(customDataIdentifierIds));
            return this;
        }

        public final void setCustomDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getInitialRun() {
            return this.initialRun;
        }

        @Override
        public final Builder initialRun(Boolean initialRun) {
            this.initialRun = initialRun;
            return this;
        }

        public final void setInitialRun(Boolean initialRun) {
            this.initialRun = initialRun;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final Instant getLastRunTime() {
            return this.lastRunTime;
        }

        @Override
        public final Builder lastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
            return this;
        }

        public final void setLastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final S3JobDefinition.Builder getS3JobDefinition() {
            return this.s3JobDefinition != null ? this.s3JobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder s3JobDefinition(S3JobDefinition s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition;
            return this;
        }

        public final void setS3JobDefinition(S3JobDefinition.BuilderImpl s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition != null ? s3JobDefinition.build() : null;
        }

        public final Integer getSamplingPercentage() {
            return this.samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        public final JobScheduleFrequency.Builder getScheduleFrequency() {
            return this.scheduleFrequency != null ? this.scheduleFrequency.toBuilder() : null;
        }

        @Override
        public final Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency;
            return this;
        }

        public final void setScheduleFrequency(JobScheduleFrequency.BuilderImpl scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency != null ? scheduleFrequency.build() : null;
        }

        public final Statistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(Statistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final UserPausedDetails.Builder getUserPausedDetails() {
            return this.userPausedDetails != null ? this.userPausedDetails.toBuilder() : null;
        }

        @Override
        public final Builder userPausedDetails(UserPausedDetails userPausedDetails) {
            this.userPausedDetails = userPausedDetails;
            return this;
        }

        public final void setUserPausedDetails(UserPausedDetails.BuilderImpl userPausedDetails) {
            this.userPausedDetails = userPausedDetails != null ? userPausedDetails.build() : null;
        }

        @Override
        public DescribeClassificationJobResponse build() {
            return new DescribeClassificationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClassificationJobResponse> {
        public Builder clientToken(String var1);

        public Builder createdAt(Instant var1);

        public Builder customDataIdentifierIds(Collection<String> var1);

        public Builder customDataIdentifierIds(String ... var1);

        public Builder description(String var1);

        public Builder initialRun(Boolean var1);

        public Builder jobArn(String var1);

        public Builder jobId(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder lastRunTime(Instant var1);

        public Builder name(String var1);

        public Builder s3JobDefinition(S3JobDefinition var1);

        default public Builder s3JobDefinition(Consumer<S3JobDefinition.Builder> s3JobDefinition) {
            return this.s3JobDefinition((S3JobDefinition)((S3JobDefinition.Builder)S3JobDefinition.builder().applyMutation(s3JobDefinition)).build());
        }

        public Builder samplingPercentage(Integer var1);

        public Builder scheduleFrequency(JobScheduleFrequency var1);

        default public Builder scheduleFrequency(Consumer<JobScheduleFrequency.Builder> scheduleFrequency) {
            return this.scheduleFrequency((JobScheduleFrequency)((JobScheduleFrequency.Builder)JobScheduleFrequency.builder().applyMutation(scheduleFrequency)).build());
        }

        public Builder statistics(Statistics var1);

        default public Builder statistics(Consumer<Statistics.Builder> statistics) {
            return this.statistics((Statistics)((Statistics.Builder)Statistics.builder().applyMutation(statistics)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder userPausedDetails(UserPausedDetails var1);

        default public Builder userPausedDetails(Consumer<UserPausedDetails.Builder> userPausedDetails) {
            return this.userPausedDetails((UserPausedDetails)((UserPausedDetails.Builder)UserPausedDetails.builder().applyMutation(userPausedDetails)).build());
        }
    }
}

