/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigurationResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoEnable").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::autoEnable)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()}).build();
    private static final SdkField<Boolean> MAX_ACCOUNT_LIMIT_REACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("maxAccountLimitReached").getter(DescribeOrganizationConfigurationResponse.getter(DescribeOrganizationConfigurationResponse::maxAccountLimitReached)).setter(DescribeOrganizationConfigurationResponse.setter(Builder::maxAccountLimitReached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAccountLimitReached").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD, MAX_ACCOUNT_LIMIT_REACHED_FIELD));
    private final Boolean autoEnable;
    private final Boolean maxAccountLimitReached;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.maxAccountLimitReached = builder.maxAccountLimitReached;
    }

    public Boolean autoEnable() {
        return this.autoEnable;
    }

    public Boolean maxAccountLimitReached() {
        return this.maxAccountLimitReached;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAccountLimitReached());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse)((Object)obj);
        return Objects.equals(this.autoEnable(), other.autoEnable()) && Objects.equals(this.maxAccountLimitReached(), other.maxAccountLimitReached());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigurationResponse").add("AutoEnable", (Object)this.autoEnable()).add("MaxAccountLimitReached", (Object)this.maxAccountLimitReached()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnable()));
            }
            case "maxAccountLimitReached": {
                return Optional.ofNullable(clazz.cast(this.maxAccountLimitReached()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private Boolean autoEnable;
        private Boolean maxAccountLimitReached;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            this.autoEnable(model.autoEnable);
            this.maxAccountLimitReached(model.maxAccountLimitReached);
        }

        public final Boolean getAutoEnable() {
            return this.autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        public final Boolean getMaxAccountLimitReached() {
            return this.maxAccountLimitReached;
        }

        @Override
        public final Builder maxAccountLimitReached(Boolean maxAccountLimitReached) {
            this.maxAccountLimitReached = maxAccountLimitReached;
            return this;
        }

        public final void setMaxAccountLimitReached(Boolean maxAccountLimitReached) {
            this.maxAccountLimitReached = maxAccountLimitReached;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        public Builder autoEnable(Boolean var1);

        public Builder maxAccountLimitReached(Boolean var1);
    }
}

