/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.ClassificationDetails;
import software.amazon.awssdk.services.macie2.model.FindingCategory;
import software.amazon.awssdk.services.macie2.model.FindingType;
import software.amazon.awssdk.services.macie2.model.PolicyDetails;
import software.amazon.awssdk.services.macie2.model.ResourcesAffected;
import software.amazon.awssdk.services.macie2.model.Severity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Finding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Finding> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::accountId)).setter(Finding.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Boolean> ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Finding.getter(Finding::archived)).setter(Finding.setter(Builder::archived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archived").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::categoryAsString)).setter(Finding.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<ClassificationDetails> CLASSIFICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Finding.getter(Finding::classificationDetails)).setter(Finding.setter(Builder::classificationDetails)).constructor(ClassificationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationDetails").build()}).build();
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(Finding.getter(Finding::count)).setter(Finding.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Finding.getter(Finding::createdAt)).setter(Finding.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::description)).setter(Finding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::id)).setter(Finding.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::partition)).setter(Finding.setter(Builder::partition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partition").build()}).build();
    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Finding.getter(Finding::policyDetails)).setter(Finding.setter(Builder::policyDetails)).constructor(PolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDetails").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::region)).setter(Finding.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<ResourcesAffected> RESOURCES_AFFECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Finding.getter(Finding::resourcesAffected)).setter(Finding.setter(Builder::resourcesAffected)).constructor(ResourcesAffected::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesAffected").build()}).build();
    private static final SdkField<Boolean> SAMPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Finding.getter(Finding::sample)).setter(Finding.setter(Builder::sample)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sample").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::schemaVersion)).setter(Finding.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<Severity> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Finding.getter(Finding::severity)).setter(Finding.setter(Builder::severity)).constructor(Severity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::title)).setter(Finding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Finding.getter(Finding::typeAsString)).setter(Finding.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Finding.getter(Finding::updatedAt)).setter(Finding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ARCHIVED_FIELD, CATEGORY_FIELD, CLASSIFICATION_DETAILS_FIELD, COUNT_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, PARTITION_FIELD, POLICY_DETAILS_FIELD, REGION_FIELD, RESOURCES_AFFECTED_FIELD, SAMPLE_FIELD, SCHEMA_VERSION_FIELD, SEVERITY_FIELD, TITLE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Boolean archived;
    private final String category;
    private final ClassificationDetails classificationDetails;
    private final Long count;
    private final Instant createdAt;
    private final String description;
    private final String id;
    private final String partition;
    private final PolicyDetails policyDetails;
    private final String region;
    private final ResourcesAffected resourcesAffected;
    private final Boolean sample;
    private final String schemaVersion;
    private final Severity severity;
    private final String title;
    private final String type;
    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.archived = builder.archived;
        this.category = builder.category;
        this.classificationDetails = builder.classificationDetails;
        this.count = builder.count;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.partition = builder.partition;
        this.policyDetails = builder.policyDetails;
        this.region = builder.region;
        this.resourcesAffected = builder.resourcesAffected;
        this.sample = builder.sample;
        this.schemaVersion = builder.schemaVersion;
        this.severity = builder.severity;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    public String accountId() {
        return this.accountId;
    }

    public Boolean archived() {
        return this.archived;
    }

    public FindingCategory category() {
        return FindingCategory.fromValue(this.category);
    }

    public String categoryAsString() {
        return this.category;
    }

    public ClassificationDetails classificationDetails() {
        return this.classificationDetails;
    }

    public Long count() {
        return this.count;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public String id() {
        return this.id;
    }

    public String partition() {
        return this.partition;
    }

    public PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    public String region() {
        return this.region;
    }

    public ResourcesAffected resourcesAffected() {
        return this.resourcesAffected;
    }

    public Boolean sample() {
        return this.sample;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public Severity severity() {
        return this.severity;
    }

    public String title() {
        return this.title;
    }

    public FindingType type() {
        return FindingType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.archived());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.classificationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.partition());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesAffected());
        hashCode = 31 * hashCode + Objects.hashCode(this.sample());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.archived(), other.archived()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.classificationDetails(), other.classificationDetails()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.partition(), other.partition()) && Objects.equals(this.policyDetails(), other.policyDetails()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourcesAffected(), other.resourcesAffected()) && Objects.equals(this.sample(), other.sample()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"Finding").add("AccountId", (Object)this.accountId()).add("Archived", (Object)this.archived()).add("Category", (Object)this.categoryAsString()).add("ClassificationDetails", (Object)this.classificationDetails()).add("Count", (Object)this.count()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Partition", (Object)this.partition()).add("PolicyDetails", (Object)this.policyDetails()).add("Region", (Object)this.region()).add("ResourcesAffected", (Object)this.resourcesAffected()).add("Sample", (Object)this.sample()).add("SchemaVersion", (Object)this.schemaVersion()).add("Severity", (Object)this.severity()).add("Title", (Object)this.title()).add("Type", (Object)this.typeAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "archived": {
                return Optional.ofNullable(clazz.cast(this.archived()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "classificationDetails": {
                return Optional.ofNullable(clazz.cast(this.classificationDetails()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "partition": {
                return Optional.ofNullable(clazz.cast(this.partition()));
            }
            case "policyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "resourcesAffected": {
                return Optional.ofNullable(clazz.cast(this.resourcesAffected()));
            }
            case "sample": {
                return Optional.ofNullable(clazz.cast(this.sample()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Boolean archived;
        private String category;
        private ClassificationDetails classificationDetails;
        private Long count;
        private Instant createdAt;
        private String description;
        private String id;
        private String partition;
        private PolicyDetails policyDetails;
        private String region;
        private ResourcesAffected resourcesAffected;
        private Boolean sample;
        private String schemaVersion;
        private Severity severity;
        private String title;
        private String type;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            this.accountId(model.accountId);
            this.archived(model.archived);
            this.category(model.category);
            this.classificationDetails(model.classificationDetails);
            this.count(model.count);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.id(model.id);
            this.partition(model.partition);
            this.policyDetails(model.policyDetails);
            this.region(model.region);
            this.resourcesAffected(model.resourcesAffected);
            this.sample(model.sample);
            this.schemaVersion(model.schemaVersion);
            this.severity(model.severity);
            this.title(model.title);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Boolean getArchived() {
            return this.archived;
        }

        @Override
        public final Builder archived(Boolean archived) {
            this.archived = archived;
            return this;
        }

        public final void setArchived(Boolean archived) {
            this.archived = archived;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(FindingCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final ClassificationDetails.Builder getClassificationDetails() {
            return this.classificationDetails != null ? this.classificationDetails.toBuilder() : null;
        }

        @Override
        public final Builder classificationDetails(ClassificationDetails classificationDetails) {
            this.classificationDetails = classificationDetails;
            return this;
        }

        public final void setClassificationDetails(ClassificationDetails.BuilderImpl classificationDetails) {
            this.classificationDetails = classificationDetails != null ? classificationDetails.build() : null;
        }

        public final Long getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPartition() {
            return this.partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return this.policyDetails != null ? this.policyDetails.toBuilder() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final ResourcesAffected.Builder getResourcesAffected() {
            return this.resourcesAffected != null ? this.resourcesAffected.toBuilder() : null;
        }

        @Override
        public final Builder resourcesAffected(ResourcesAffected resourcesAffected) {
            this.resourcesAffected = resourcesAffected;
            return this;
        }

        public final void setResourcesAffected(ResourcesAffected.BuilderImpl resourcesAffected) {
            this.resourcesAffected = resourcesAffected != null ? resourcesAffected.build() : null;
        }

        public final Boolean getSample() {
            return this.sample;
        }

        @Override
        public final Builder sample(Boolean sample) {
            this.sample = sample;
            return this;
        }

        public final void setSample(Boolean sample) {
            this.sample = sample;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final Severity.Builder getSeverity() {
            return this.severity != null ? this.severity.toBuilder() : null;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(Severity.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FindingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public Finding build() {
            return new Finding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Finding> {
        public Builder accountId(String var1);

        public Builder archived(Boolean var1);

        public Builder category(String var1);

        public Builder category(FindingCategory var1);

        public Builder classificationDetails(ClassificationDetails var1);

        default public Builder classificationDetails(Consumer<ClassificationDetails.Builder> classificationDetails) {
            return this.classificationDetails((ClassificationDetails)((ClassificationDetails.Builder)ClassificationDetails.builder().applyMutation(classificationDetails)).build());
        }

        public Builder count(Long var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder partition(String var1);

        public Builder policyDetails(PolicyDetails var1);

        default public Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return this.policyDetails((PolicyDetails)((PolicyDetails.Builder)PolicyDetails.builder().applyMutation(policyDetails)).build());
        }

        public Builder region(String var1);

        public Builder resourcesAffected(ResourcesAffected var1);

        default public Builder resourcesAffected(Consumer<ResourcesAffected.Builder> resourcesAffected) {
            return this.resourcesAffected((ResourcesAffected)((ResourcesAffected.Builder)ResourcesAffected.builder().applyMutation(resourcesAffected)).build());
        }

        public Builder sample(Boolean var1);

        public Builder schemaVersion(String var1);

        public Builder severity(Severity var1);

        default public Builder severity(Consumer<Severity.Builder> severity) {
            return this.severity((Severity)((Severity.Builder)Severity.builder().applyMutation(severity)).build());
        }

        public Builder title(String var1);

        public Builder type(String var1);

        public Builder type(FindingType var1);

        public Builder updatedAt(Instant var1);
    }
}

