/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.MacieStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMemberSessionRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, UpdateMemberSessionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMemberSessionRequest.getter(UpdateMemberSessionRequest::id)).setter(UpdateMemberSessionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMemberSessionRequest.getter(UpdateMemberSessionRequest::statusAsString)).setter(UpdateMemberSessionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD));
    private final String id;
    private final String status;

    private UpdateMemberSessionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.status = builder.status;
    }

    public String id() {
        return this.id;
    }

    public MacieStatus status() {
        return MacieStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMemberSessionRequest)) {
            return false;
        }
        UpdateMemberSessionRequest other = (UpdateMemberSessionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMemberSessionRequest").add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMemberSessionRequest, T> g) {
        return obj -> g.apply((UpdateMemberSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String id;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMemberSessionRequest model) {
            super(model);
            this.id(model.id);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MacieStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMemberSessionRequest build() {
            return new UpdateMemberSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMemberSessionRequest> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(MacieStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

