/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.BucketPublicAccess;
import software.amazon.awssdk.services.macie2.model.KeyValuePair;
import software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType;
import software.amazon.awssdk.services.macie2.model.ReplicationDetails;
import software.amazon.awssdk.services.macie2.model.SharedAccess;
import software.amazon.awssdk.services.macie2.model.___listOfKeyValuePairCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketMetadata> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BucketMetadata.getter(BucketMetadata::accountId)).setter(BucketMetadata.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BucketMetadata.getter(BucketMetadata::bucketArn)).setter(BucketMetadata.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()}).build();
    private static final SdkField<Instant> BUCKET_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BucketMetadata.getter(BucketMetadata::bucketCreatedAt)).setter(BucketMetadata.setter(Builder::bucketCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BucketMetadata.getter(BucketMetadata::bucketName)).setter(BucketMetadata.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<Long> CLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BucketMetadata.getter(BucketMetadata::classifiableObjectCount)).setter(BucketMetadata.setter(Builder::classifiableObjectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableObjectCount").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BucketMetadata.getter(BucketMetadata::lastUpdated)).setter(BucketMetadata.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Long> OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BucketMetadata.getter(BucketMetadata::objectCount)).setter(BucketMetadata.setter(Builder::objectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectCount").build()}).build();
    private static final SdkField<ObjectCountByEncryptionType> OBJECT_COUNT_BY_ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BucketMetadata.getter(BucketMetadata::objectCountByEncryptionType)).setter(BucketMetadata.setter(Builder::objectCountByEncryptionType)).constructor(ObjectCountByEncryptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectCountByEncryptionType").build()}).build();
    private static final SdkField<BucketPublicAccess> PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BucketMetadata.getter(BucketMetadata::publicAccess)).setter(BucketMetadata.setter(Builder::publicAccess)).constructor(BucketPublicAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccess").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BucketMetadata.getter(BucketMetadata::region)).setter(BucketMetadata.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<ReplicationDetails> REPLICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BucketMetadata.getter(BucketMetadata::replicationDetails)).setter(BucketMetadata.setter(Builder::replicationDetails)).constructor(ReplicationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationDetails").build()}).build();
    private static final SdkField<String> SHARED_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BucketMetadata.getter(BucketMetadata::sharedAccessAsString)).setter(BucketMetadata.setter(Builder::sharedAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAccess").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BucketMetadata.getter(BucketMetadata::sizeInBytes)).setter(BucketMetadata.setter(Builder::sizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytes").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_COMPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BucketMetadata.getter(BucketMetadata::sizeInBytesCompressed)).setter(BucketMetadata.setter(Builder::sizeInBytesCompressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytesCompressed").build()}).build();
    private static final SdkField<List<KeyValuePair>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BucketMetadata.getter(BucketMetadata::tags)).setter(BucketMetadata.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> VERSIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(BucketMetadata.getter(BucketMetadata::versioning)).setter(BucketMetadata.setter(Builder::versioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUCKET_ARN_FIELD, BUCKET_CREATED_AT_FIELD, BUCKET_NAME_FIELD, CLASSIFIABLE_OBJECT_COUNT_FIELD, LAST_UPDATED_FIELD, OBJECT_COUNT_FIELD, OBJECT_COUNT_BY_ENCRYPTION_TYPE_FIELD, PUBLIC_ACCESS_FIELD, REGION_FIELD, REPLICATION_DETAILS_FIELD, SHARED_ACCESS_FIELD, SIZE_IN_BYTES_FIELD, SIZE_IN_BYTES_COMPRESSED_FIELD, TAGS_FIELD, VERSIONING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String bucketArn;
    private final Instant bucketCreatedAt;
    private final String bucketName;
    private final Long classifiableObjectCount;
    private final Instant lastUpdated;
    private final Long objectCount;
    private final ObjectCountByEncryptionType objectCountByEncryptionType;
    private final BucketPublicAccess publicAccess;
    private final String region;
    private final ReplicationDetails replicationDetails;
    private final String sharedAccess;
    private final Long sizeInBytes;
    private final Long sizeInBytesCompressed;
    private final List<KeyValuePair> tags;
    private final Boolean versioning;

    private BucketMetadata(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.bucketArn = builder.bucketArn;
        this.bucketCreatedAt = builder.bucketCreatedAt;
        this.bucketName = builder.bucketName;
        this.classifiableObjectCount = builder.classifiableObjectCount;
        this.lastUpdated = builder.lastUpdated;
        this.objectCount = builder.objectCount;
        this.objectCountByEncryptionType = builder.objectCountByEncryptionType;
        this.publicAccess = builder.publicAccess;
        this.region = builder.region;
        this.replicationDetails = builder.replicationDetails;
        this.sharedAccess = builder.sharedAccess;
        this.sizeInBytes = builder.sizeInBytes;
        this.sizeInBytesCompressed = builder.sizeInBytesCompressed;
        this.tags = builder.tags;
        this.versioning = builder.versioning;
    }

    public String accountId() {
        return this.accountId;
    }

    public String bucketArn() {
        return this.bucketArn;
    }

    public Instant bucketCreatedAt() {
        return this.bucketCreatedAt;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public Long classifiableObjectCount() {
        return this.classifiableObjectCount;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Long objectCount() {
        return this.objectCount;
    }

    public ObjectCountByEncryptionType objectCountByEncryptionType() {
        return this.objectCountByEncryptionType;
    }

    public BucketPublicAccess publicAccess() {
        return this.publicAccess;
    }

    public String region() {
        return this.region;
    }

    public ReplicationDetails replicationDetails() {
        return this.replicationDetails;
    }

    public SharedAccess sharedAccess() {
        return SharedAccess.fromValue(this.sharedAccess);
    }

    public String sharedAccessAsString() {
        return this.sharedAccess;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Long sizeInBytesCompressed() {
        return this.sizeInBytesCompressed;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<KeyValuePair> tags() {
        return this.tags;
    }

    public Boolean versioning() {
        return this.versioning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectCountByEncryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytesCompressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.versioning());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketMetadata)) {
            return false;
        }
        BucketMetadata other = (BucketMetadata)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.bucketCreatedAt(), other.bucketCreatedAt()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.classifiableObjectCount(), other.classifiableObjectCount()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.objectCount(), other.objectCount()) && Objects.equals(this.objectCountByEncryptionType(), other.objectCountByEncryptionType()) && Objects.equals(this.publicAccess(), other.publicAccess()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.replicationDetails(), other.replicationDetails()) && Objects.equals(this.sharedAccessAsString(), other.sharedAccessAsString()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.sizeInBytesCompressed(), other.sizeInBytesCompressed()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.versioning(), other.versioning());
    }

    public String toString() {
        return ToString.builder((String)"BucketMetadata").add("AccountId", (Object)this.accountId()).add("BucketArn", (Object)this.bucketArn()).add("BucketCreatedAt", (Object)this.bucketCreatedAt()).add("BucketName", (Object)this.bucketName()).add("ClassifiableObjectCount", (Object)this.classifiableObjectCount()).add("LastUpdated", (Object)this.lastUpdated()).add("ObjectCount", (Object)this.objectCount()).add("ObjectCountByEncryptionType", (Object)this.objectCountByEncryptionType()).add("PublicAccess", (Object)this.publicAccess()).add("Region", (Object)this.region()).add("ReplicationDetails", (Object)this.replicationDetails()).add("SharedAccess", (Object)this.sharedAccessAsString()).add("SizeInBytes", (Object)this.sizeInBytes()).add("SizeInBytesCompressed", (Object)this.sizeInBytesCompressed()).add("Tags", this.tags()).add("Versioning", (Object)this.versioning()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "bucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "bucketCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.bucketCreatedAt()));
            }
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "classifiableObjectCount": {
                return Optional.ofNullable(clazz.cast(this.classifiableObjectCount()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "objectCount": {
                return Optional.ofNullable(clazz.cast(this.objectCount()));
            }
            case "objectCountByEncryptionType": {
                return Optional.ofNullable(clazz.cast(this.objectCountByEncryptionType()));
            }
            case "publicAccess": {
                return Optional.ofNullable(clazz.cast(this.publicAccess()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "replicationDetails": {
                return Optional.ofNullable(clazz.cast(this.replicationDetails()));
            }
            case "sharedAccess": {
                return Optional.ofNullable(clazz.cast(this.sharedAccessAsString()));
            }
            case "sizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
            case "sizeInBytesCompressed": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytesCompressed()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "versioning": {
                return Optional.ofNullable(clazz.cast(this.versioning()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketMetadata, T> g) {
        return obj -> g.apply((BucketMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String bucketArn;
        private Instant bucketCreatedAt;
        private String bucketName;
        private Long classifiableObjectCount;
        private Instant lastUpdated;
        private Long objectCount;
        private ObjectCountByEncryptionType objectCountByEncryptionType;
        private BucketPublicAccess publicAccess;
        private String region;
        private ReplicationDetails replicationDetails;
        private String sharedAccess;
        private Long sizeInBytes;
        private Long sizeInBytesCompressed;
        private List<KeyValuePair> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean versioning;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketMetadata model) {
            this.accountId(model.accountId);
            this.bucketArn(model.bucketArn);
            this.bucketCreatedAt(model.bucketCreatedAt);
            this.bucketName(model.bucketName);
            this.classifiableObjectCount(model.classifiableObjectCount);
            this.lastUpdated(model.lastUpdated);
            this.objectCount(model.objectCount);
            this.objectCountByEncryptionType(model.objectCountByEncryptionType);
            this.publicAccess(model.publicAccess);
            this.region(model.region);
            this.replicationDetails(model.replicationDetails);
            this.sharedAccess(model.sharedAccess);
            this.sizeInBytes(model.sizeInBytes);
            this.sizeInBytesCompressed(model.sizeInBytesCompressed);
            this.tags(model.tags);
            this.versioning(model.versioning);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        public final Instant getBucketCreatedAt() {
            return this.bucketCreatedAt;
        }

        @Override
        public final Builder bucketCreatedAt(Instant bucketCreatedAt) {
            this.bucketCreatedAt = bucketCreatedAt;
            return this;
        }

        public final void setBucketCreatedAt(Instant bucketCreatedAt) {
            this.bucketCreatedAt = bucketCreatedAt;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final Long getClassifiableObjectCount() {
            return this.classifiableObjectCount;
        }

        @Override
        public final Builder classifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
            return this;
        }

        public final void setClassifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Long getObjectCount() {
            return this.objectCount;
        }

        @Override
        public final Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final void setObjectCount(Long objectCount) {
            this.objectCount = objectCount;
        }

        public final ObjectCountByEncryptionType.Builder getObjectCountByEncryptionType() {
            return this.objectCountByEncryptionType != null ? this.objectCountByEncryptionType.toBuilder() : null;
        }

        @Override
        public final Builder objectCountByEncryptionType(ObjectCountByEncryptionType objectCountByEncryptionType) {
            this.objectCountByEncryptionType = objectCountByEncryptionType;
            return this;
        }

        public final void setObjectCountByEncryptionType(ObjectCountByEncryptionType.BuilderImpl objectCountByEncryptionType) {
            this.objectCountByEncryptionType = objectCountByEncryptionType != null ? objectCountByEncryptionType.build() : null;
        }

        public final BucketPublicAccess.Builder getPublicAccess() {
            return this.publicAccess != null ? this.publicAccess.toBuilder() : null;
        }

        @Override
        public final Builder publicAccess(BucketPublicAccess publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public final void setPublicAccess(BucketPublicAccess.BuilderImpl publicAccess) {
            this.publicAccess = publicAccess != null ? publicAccess.build() : null;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final ReplicationDetails.Builder getReplicationDetails() {
            return this.replicationDetails != null ? this.replicationDetails.toBuilder() : null;
        }

        @Override
        public final Builder replicationDetails(ReplicationDetails replicationDetails) {
            this.replicationDetails = replicationDetails;
            return this;
        }

        public final void setReplicationDetails(ReplicationDetails.BuilderImpl replicationDetails) {
            this.replicationDetails = replicationDetails != null ? replicationDetails.build() : null;
        }

        public final String getSharedAccess() {
            return this.sharedAccess;
        }

        @Override
        public final Builder sharedAccess(String sharedAccess) {
            this.sharedAccess = sharedAccess;
            return this;
        }

        @Override
        public final Builder sharedAccess(SharedAccess sharedAccess) {
            this.sharedAccess(sharedAccess == null ? null : sharedAccess.toString());
            return this;
        }

        public final void setSharedAccess(String sharedAccess) {
            this.sharedAccess = sharedAccess;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final Long getSizeInBytesCompressed() {
            return this.sizeInBytesCompressed;
        }

        @Override
        public final Builder sizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
            return this;
        }

        public final void setSizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
        }

        public final Collection<KeyValuePair.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<KeyValuePair> tags) {
            this.tags = ___listOfKeyValuePairCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(KeyValuePair ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<KeyValuePair.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<KeyValuePair.BuilderImpl> tags) {
            this.tags = ___listOfKeyValuePairCopier.copyFromBuilder(tags);
        }

        public final Boolean getVersioning() {
            return this.versioning;
        }

        @Override
        public final Builder versioning(Boolean versioning) {
            this.versioning = versioning;
            return this;
        }

        public final void setVersioning(Boolean versioning) {
            this.versioning = versioning;
        }

        public BucketMetadata build() {
            return new BucketMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketMetadata> {
        public Builder accountId(String var1);

        public Builder bucketArn(String var1);

        public Builder bucketCreatedAt(Instant var1);

        public Builder bucketName(String var1);

        public Builder classifiableObjectCount(Long var1);

        public Builder lastUpdated(Instant var1);

        public Builder objectCount(Long var1);

        public Builder objectCountByEncryptionType(ObjectCountByEncryptionType var1);

        default public Builder objectCountByEncryptionType(Consumer<ObjectCountByEncryptionType.Builder> objectCountByEncryptionType) {
            return this.objectCountByEncryptionType((ObjectCountByEncryptionType)((ObjectCountByEncryptionType.Builder)ObjectCountByEncryptionType.builder().applyMutation(objectCountByEncryptionType)).build());
        }

        public Builder publicAccess(BucketPublicAccess var1);

        default public Builder publicAccess(Consumer<BucketPublicAccess.Builder> publicAccess) {
            return this.publicAccess((BucketPublicAccess)((BucketPublicAccess.Builder)BucketPublicAccess.builder().applyMutation(publicAccess)).build());
        }

        public Builder region(String var1);

        public Builder replicationDetails(ReplicationDetails var1);

        default public Builder replicationDetails(Consumer<ReplicationDetails.Builder> replicationDetails) {
            return this.replicationDetails((ReplicationDetails)((ReplicationDetails.Builder)ReplicationDetails.builder().applyMutation(replicationDetails)).build());
        }

        public Builder sharedAccess(String var1);

        public Builder sharedAccess(SharedAccess var1);

        public Builder sizeInBytes(Long var1);

        public Builder sizeInBytesCompressed(Long var1);

        public Builder tags(Collection<KeyValuePair> var1);

        public Builder tags(KeyValuePair ... var1);

        public Builder tags(Consumer<KeyValuePair.Builder> ... var1);

        public Builder versioning(Boolean var1);
    }
}

