/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.DailySchedule;
import software.amazon.awssdk.services.macie2.model.MonthlySchedule;
import software.amazon.awssdk.services.macie2.model.WeeklySchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobScheduleFrequency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobScheduleFrequency> {
    private static final SdkField<DailySchedule> DAILY_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobScheduleFrequency.getter(JobScheduleFrequency::dailySchedule)).setter(JobScheduleFrequency.setter(Builder::dailySchedule)).constructor(DailySchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dailySchedule").build()}).build();
    private static final SdkField<MonthlySchedule> MONTHLY_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobScheduleFrequency.getter(JobScheduleFrequency::monthlySchedule)).setter(JobScheduleFrequency.setter(Builder::monthlySchedule)).constructor(MonthlySchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlySchedule").build()}).build();
    private static final SdkField<WeeklySchedule> WEEKLY_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobScheduleFrequency.getter(JobScheduleFrequency::weeklySchedule)).setter(JobScheduleFrequency.setter(Builder::weeklySchedule)).constructor(WeeklySchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weeklySchedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_SCHEDULE_FIELD, MONTHLY_SCHEDULE_FIELD, WEEKLY_SCHEDULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final DailySchedule dailySchedule;
    private final MonthlySchedule monthlySchedule;
    private final WeeklySchedule weeklySchedule;

    private JobScheduleFrequency(BuilderImpl builder) {
        this.dailySchedule = builder.dailySchedule;
        this.monthlySchedule = builder.monthlySchedule;
        this.weeklySchedule = builder.weeklySchedule;
    }

    public DailySchedule dailySchedule() {
        return this.dailySchedule;
    }

    public MonthlySchedule monthlySchedule() {
        return this.monthlySchedule;
    }

    public WeeklySchedule weeklySchedule() {
        return this.weeklySchedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dailySchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlySchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklySchedule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobScheduleFrequency)) {
            return false;
        }
        JobScheduleFrequency other = (JobScheduleFrequency)obj;
        return Objects.equals(this.dailySchedule(), other.dailySchedule()) && Objects.equals(this.monthlySchedule(), other.monthlySchedule()) && Objects.equals(this.weeklySchedule(), other.weeklySchedule());
    }

    public String toString() {
        return ToString.builder((String)"JobScheduleFrequency").add("DailySchedule", (Object)this.dailySchedule()).add("MonthlySchedule", (Object)this.monthlySchedule()).add("WeeklySchedule", (Object)this.weeklySchedule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dailySchedule": {
                return Optional.ofNullable(clazz.cast(this.dailySchedule()));
            }
            case "monthlySchedule": {
                return Optional.ofNullable(clazz.cast(this.monthlySchedule()));
            }
            case "weeklySchedule": {
                return Optional.ofNullable(clazz.cast(this.weeklySchedule()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobScheduleFrequency, T> g) {
        return obj -> g.apply((JobScheduleFrequency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DailySchedule dailySchedule;
        private MonthlySchedule monthlySchedule;
        private WeeklySchedule weeklySchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(JobScheduleFrequency model) {
            this.dailySchedule(model.dailySchedule);
            this.monthlySchedule(model.monthlySchedule);
            this.weeklySchedule(model.weeklySchedule);
        }

        public final DailySchedule.Builder getDailySchedule() {
            return this.dailySchedule != null ? this.dailySchedule.toBuilder() : null;
        }

        @Override
        public final Builder dailySchedule(DailySchedule dailySchedule) {
            this.dailySchedule = dailySchedule;
            return this;
        }

        public final void setDailySchedule(DailySchedule.BuilderImpl dailySchedule) {
            this.dailySchedule = dailySchedule != null ? dailySchedule.build() : null;
        }

        public final MonthlySchedule.Builder getMonthlySchedule() {
            return this.monthlySchedule != null ? this.monthlySchedule.toBuilder() : null;
        }

        @Override
        public final Builder monthlySchedule(MonthlySchedule monthlySchedule) {
            this.monthlySchedule = monthlySchedule;
            return this;
        }

        public final void setMonthlySchedule(MonthlySchedule.BuilderImpl monthlySchedule) {
            this.monthlySchedule = monthlySchedule != null ? monthlySchedule.build() : null;
        }

        public final WeeklySchedule.Builder getWeeklySchedule() {
            return this.weeklySchedule != null ? this.weeklySchedule.toBuilder() : null;
        }

        @Override
        public final Builder weeklySchedule(WeeklySchedule weeklySchedule) {
            this.weeklySchedule = weeklySchedule;
            return this;
        }

        public final void setWeeklySchedule(WeeklySchedule.BuilderImpl weeklySchedule) {
            this.weeklySchedule = weeklySchedule != null ? weeklySchedule.build() : null;
        }

        public JobScheduleFrequency build() {
            return new JobScheduleFrequency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobScheduleFrequency> {
        public Builder dailySchedule(DailySchedule var1);

        default public Builder dailySchedule(Consumer<DailySchedule.Builder> dailySchedule) {
            return this.dailySchedule((DailySchedule)((DailySchedule.Builder)DailySchedule.builder().applyMutation(dailySchedule)).build());
        }

        public Builder monthlySchedule(MonthlySchedule var1);

        default public Builder monthlySchedule(Consumer<MonthlySchedule.Builder> monthlySchedule) {
            return this.monthlySchedule((MonthlySchedule)((MonthlySchedule.Builder)MonthlySchedule.builder().applyMutation(monthlySchedule)).build());
        }

        public Builder weeklySchedule(WeeklySchedule var1);

        default public Builder weeklySchedule(Consumer<WeeklySchedule.Builder> weeklySchedule) {
            return this.weeklySchedule((WeeklySchedule)((WeeklySchedule.Builder)WeeklySchedule.builder().applyMutation(weeklySchedule)).build());
        }
    }
}

