/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3OneTimeClassificationType {
    FULL("FULL"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3OneTimeClassificationType> VALUE_MAP;
    private final String value;

    private S3OneTimeClassificationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3OneTimeClassificationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3OneTimeClassificationType> knownValues() {
        EnumSet<S3OneTimeClassificationType> knownValues = EnumSet.allOf(S3OneTimeClassificationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3OneTimeClassificationType.class, S3OneTimeClassificationType::toString);
    }
}

