/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.BatchPredictionFilterVariable;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBatchPredictionsRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, DescribeBatchPredictionsRequest> {
    private static final SdkField<String> FILTER_VARIABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::filterVariableAsString)).setter(DescribeBatchPredictionsRequest.setter(Builder::filterVariable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterVariable").build()}).build();
    private static final SdkField<String> EQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::eq)).setter(DescribeBatchPredictionsRequest.setter(Builder::eq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EQ").build()}).build();
    private static final SdkField<String> GT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::gt)).setter(DescribeBatchPredictionsRequest.setter(Builder::gt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GT").build()}).build();
    private static final SdkField<String> LT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::lt)).setter(DescribeBatchPredictionsRequest.setter(Builder::lt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LT").build()}).build();
    private static final SdkField<String> GE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::ge)).setter(DescribeBatchPredictionsRequest.setter(Builder::ge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GE").build()}).build();
    private static final SdkField<String> LE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::le)).setter(DescribeBatchPredictionsRequest.setter(Builder::le)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LE").build()}).build();
    private static final SdkField<String> NE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::ne)).setter(DescribeBatchPredictionsRequest.setter(Builder::ne)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NE").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::prefix)).setter(DescribeBatchPredictionsRequest.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::sortOrderAsString)).setter(DescribeBatchPredictionsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::nextToken)).setter(DescribeBatchPredictionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeBatchPredictionsRequest.getter(DescribeBatchPredictionsRequest::limit)).setter(DescribeBatchPredictionsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_VARIABLE_FIELD, EQ_FIELD, GT_FIELD, LT_FIELD, GE_FIELD, LE_FIELD, NE_FIELD, PREFIX_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));
    private final String filterVariable;
    private final String eq;
    private final String gt;
    private final String lt;
    private final String ge;
    private final String le;
    private final String ne;
    private final String prefix;
    private final String sortOrder;
    private final String nextToken;
    private final Integer limit;

    private DescribeBatchPredictionsRequest(BuilderImpl builder) {
        super(builder);
        this.filterVariable = builder.filterVariable;
        this.eq = builder.eq;
        this.gt = builder.gt;
        this.lt = builder.lt;
        this.ge = builder.ge;
        this.le = builder.le;
        this.ne = builder.ne;
        this.prefix = builder.prefix;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public BatchPredictionFilterVariable filterVariable() {
        return BatchPredictionFilterVariable.fromValue(this.filterVariable);
    }

    public String filterVariableAsString() {
        return this.filterVariable;
    }

    public String eq() {
        return this.eq;
    }

    public String gt() {
        return this.gt;
    }

    public String lt() {
        return this.lt;
    }

    public String ge() {
        return this.ge;
    }

    public String le() {
        return this.le;
    }

    public String ne() {
        return this.ne;
    }

    public String prefix() {
        return this.prefix;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterVariableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eq());
        hashCode = 31 * hashCode + Objects.hashCode(this.gt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lt());
        hashCode = 31 * hashCode + Objects.hashCode(this.ge());
        hashCode = 31 * hashCode + Objects.hashCode(this.le());
        hashCode = 31 * hashCode + Objects.hashCode(this.ne());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchPredictionsRequest)) {
            return false;
        }
        DescribeBatchPredictionsRequest other = (DescribeBatchPredictionsRequest)((Object)obj);
        return Objects.equals(this.filterVariableAsString(), other.filterVariableAsString()) && Objects.equals(this.eq(), other.eq()) && Objects.equals(this.gt(), other.gt()) && Objects.equals(this.lt(), other.lt()) && Objects.equals(this.ge(), other.ge()) && Objects.equals(this.le(), other.le()) && Objects.equals(this.ne(), other.ne()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBatchPredictionsRequest").add("FilterVariable", (Object)this.filterVariableAsString()).add("EQ", (Object)this.eq()).add("GT", (Object)this.gt()).add("LT", (Object)this.lt()).add("GE", (Object)this.ge()).add("LE", (Object)this.le()).add("NE", (Object)this.ne()).add("Prefix", (Object)this.prefix()).add("SortOrder", (Object)this.sortOrderAsString()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterVariable": {
                return Optional.ofNullable(clazz.cast(this.filterVariableAsString()));
            }
            case "EQ": {
                return Optional.ofNullable(clazz.cast(this.eq()));
            }
            case "GT": {
                return Optional.ofNullable(clazz.cast(this.gt()));
            }
            case "LT": {
                return Optional.ofNullable(clazz.cast(this.lt()));
            }
            case "GE": {
                return Optional.ofNullable(clazz.cast(this.ge()));
            }
            case "LE": {
                return Optional.ofNullable(clazz.cast(this.le()));
            }
            case "NE": {
                return Optional.ofNullable(clazz.cast(this.ne()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBatchPredictionsRequest, T> g) {
        return obj -> g.apply((DescribeBatchPredictionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String filterVariable;
        private String eq;
        private String gt;
        private String lt;
        private String ge;
        private String le;
        private String ne;
        private String prefix;
        private String sortOrder;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchPredictionsRequest model) {
            super(model);
            this.filterVariable(model.filterVariable);
            this.eq(model.eq);
            this.gt(model.gt);
            this.lt(model.lt);
            this.ge(model.ge);
            this.le(model.le);
            this.ne(model.ne);
            this.prefix(model.prefix);
            this.sortOrder(model.sortOrder);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getFilterVariableAsString() {
            return this.filterVariable;
        }

        @Override
        public final Builder filterVariable(String filterVariable) {
            this.filterVariable = filterVariable;
            return this;
        }

        @Override
        public final Builder filterVariable(BatchPredictionFilterVariable filterVariable) {
            this.filterVariable(filterVariable.toString());
            return this;
        }

        public final void setFilterVariable(String filterVariable) {
            this.filterVariable = filterVariable;
        }

        public final String getEq() {
            return this.eq;
        }

        @Override
        public final Builder eq(String eq) {
            this.eq = eq;
            return this;
        }

        public final void setEq(String eq) {
            this.eq = eq;
        }

        public final String getGt() {
            return this.gt;
        }

        @Override
        public final Builder gt(String gt) {
            this.gt = gt;
            return this;
        }

        public final void setGt(String gt) {
            this.gt = gt;
        }

        public final String getLt() {
            return this.lt;
        }

        @Override
        public final Builder lt(String lt) {
            this.lt = lt;
            return this;
        }

        public final void setLt(String lt) {
            this.lt = lt;
        }

        public final String getGe() {
            return this.ge;
        }

        @Override
        public final Builder ge(String ge) {
            this.ge = ge;
            return this;
        }

        public final void setGe(String ge) {
            this.ge = ge;
        }

        public final String getLe() {
            return this.le;
        }

        @Override
        public final Builder le(String le) {
            this.le = le;
            return this;
        }

        public final void setLe(String le) {
            this.le = le;
        }

        public final String getNe() {
            return this.ne;
        }

        @Override
        public final Builder ne(String ne) {
            this.ne = ne;
            return this;
        }

        public final void setNe(String ne) {
            this.ne = ne;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getSortOrderAsString() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBatchPredictionsRequest build() {
            return new DescribeBatchPredictionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBatchPredictionsRequest> {
        public Builder filterVariable(String var1);

        public Builder filterVariable(BatchPredictionFilterVariable var1);

        public Builder eq(String var1);

        public Builder gt(String var1);

        public Builder lt(String var1);

        public Builder ge(String var1);

        public Builder le(String var1);

        public Builder ne(String var1);

        public Builder prefix(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

