/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEvaluationRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateEvaluationRequest> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationId").getter(CreateEvaluationRequest.getter(CreateEvaluationRequest::evaluationId)).setter(CreateEvaluationRequest.setter(Builder::evaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()}).build();
    private static final SdkField<String> EVALUATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationName").getter(CreateEvaluationRequest.getter(CreateEvaluationRequest::evaluationName)).setter(CreateEvaluationRequest.setter(Builder::evaluationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationName").build()}).build();
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLModelId").getter(CreateEvaluationRequest.getter(CreateEvaluationRequest::mlModelId)).setter(CreateEvaluationRequest.setter(Builder::mlModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()}).build();
    private static final SdkField<String> EVALUATION_DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationDataSourceId").getter(CreateEvaluationRequest.getter(CreateEvaluationRequest::evaluationDataSourceId)).setter(CreateEvaluationRequest.setter(Builder::evaluationDataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataSourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD, EVALUATION_NAME_FIELD, ML_MODEL_ID_FIELD, EVALUATION_DATA_SOURCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEvaluationRequest.memberNameToFieldInitializer();
    private final String evaluationId;
    private final String evaluationName;
    private final String mlModelId;
    private final String evaluationDataSourceId;

    private CreateEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
        this.evaluationName = builder.evaluationName;
        this.mlModelId = builder.mlModelId;
        this.evaluationDataSourceId = builder.evaluationDataSourceId;
    }

    public final String evaluationId() {
        return this.evaluationId;
    }

    public final String evaluationName() {
        return this.evaluationName;
    }

    public final String mlModelId() {
        return this.mlModelId;
    }

    public final String evaluationDataSourceId() {
        return this.evaluationDataSourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataSourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationRequest)) {
            return false;
        }
        CreateEvaluationRequest other = (CreateEvaluationRequest)((Object)obj);
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.evaluationName(), other.evaluationName()) && Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.evaluationDataSourceId(), other.evaluationDataSourceId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEvaluationRequest").add("EvaluationId", (Object)this.evaluationId()).add("EvaluationName", (Object)this.evaluationName()).add("MLModelId", (Object)this.mlModelId()).add("EvaluationDataSourceId", (Object)this.evaluationDataSourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.ofNullable(clazz.cast(this.evaluationId()));
            }
            case "EvaluationName": {
                return Optional.ofNullable(clazz.cast(this.evaluationName()));
            }
            case "MLModelId": {
                return Optional.ofNullable(clazz.cast(this.mlModelId()));
            }
            case "EvaluationDataSourceId": {
                return Optional.ofNullable(clazz.cast(this.evaluationDataSourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("EvaluationName", EVALUATION_NAME_FIELD);
        map.put("MLModelId", ML_MODEL_ID_FIELD);
        map.put("EvaluationDataSourceId", EVALUATION_DATA_SOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEvaluationRequest, T> g) {
        return obj -> g.apply((CreateEvaluationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationName;
        private String mlModelId;
        private String evaluationDataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationRequest model) {
            super(model);
            this.evaluationId(model.evaluationId);
            this.evaluationName(model.evaluationName);
            this.mlModelId(model.mlModelId);
            this.evaluationDataSourceId(model.evaluationDataSourceId);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationName() {
            return this.evaluationName;
        }

        public final void setEvaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
        }

        @Override
        public final Builder evaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
            return this;
        }

        public final String getMlModelId() {
            return this.mlModelId;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final String getEvaluationDataSourceId() {
            return this.evaluationDataSourceId;
        }

        public final void setEvaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
        }

        @Override
        public final Builder evaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEvaluationRequest build() {
            return new CreateEvaluationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEvaluationRequest> {
        public Builder evaluationId(String var1);

        public Builder evaluationName(String var1);

        public Builder mlModelId(String var1);

        public Builder evaluationDataSourceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

