/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEvaluationRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, UpdateEvaluationRequest> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationId").getter(UpdateEvaluationRequest.getter(UpdateEvaluationRequest::evaluationId)).setter(UpdateEvaluationRequest.setter(Builder::evaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()}).build();
    private static final SdkField<String> EVALUATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationName").getter(UpdateEvaluationRequest.getter(UpdateEvaluationRequest::evaluationName)).setter(UpdateEvaluationRequest.setter(Builder::evaluationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD, EVALUATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EvaluationId", EVALUATION_ID_FIELD);
            this.put("EvaluationName", EVALUATION_NAME_FIELD);
        }
    });
    private final String evaluationId;
    private final String evaluationName;

    private UpdateEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
        this.evaluationName = builder.evaluationName;
    }

    public final String evaluationId() {
        return this.evaluationId;
    }

    public final String evaluationName() {
        return this.evaluationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEvaluationRequest)) {
            return false;
        }
        UpdateEvaluationRequest other = (UpdateEvaluationRequest)((Object)obj);
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.evaluationName(), other.evaluationName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEvaluationRequest").add("EvaluationId", (Object)this.evaluationId()).add("EvaluationName", (Object)this.evaluationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.ofNullable(clazz.cast(this.evaluationId()));
            }
            case "EvaluationName": {
                return Optional.ofNullable(clazz.cast(this.evaluationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEvaluationRequest, T> g) {
        return obj -> g.apply((UpdateEvaluationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEvaluationRequest model) {
            super(model);
            this.evaluationId(model.evaluationId);
            this.evaluationName(model.evaluationName);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationName() {
            return this.evaluationName;
        }

        public final void setEvaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
        }

        @Override
        public final Builder evaluationName(String evaluationName) {
            this.evaluationName = evaluationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEvaluationRequest build() {
            return new UpdateEvaluationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEvaluationRequest> {
        public Builder evaluationId(String var1);

        public Builder evaluationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

