/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceFilterVariable {
    CREATED_AT("CreatedAt"),
    LAST_UPDATED_AT("LastUpdatedAt"),
    STATUS("Status"),
    NAME("Name"),
    DATA_LOCATION_S3("DataLocationS3"),
    IAM_USER("IAMUser"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceFilterVariable> VALUE_MAP;
    private final String value;

    private DataSourceFilterVariable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceFilterVariable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceFilterVariable> knownValues() {
        EnumSet<DataSourceFilterVariable> knownValues = EnumSet.allOf(DataSourceFilterVariable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceFilterVariable.class, DataSourceFilterVariable::toString);
    }
}

