/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceFromRedshiftRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromRedshiftRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(CreateDataSourceFromRedshiftRequest.getter(CreateDataSourceFromRedshiftRequest::dataSourceId)).setter(CreateDataSourceFromRedshiftRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceName").getter(CreateDataSourceFromRedshiftRequest.getter(CreateDataSourceFromRedshiftRequest::dataSourceName)).setter(CreateDataSourceFromRedshiftRequest.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()}).build();
    private static final SdkField<RedshiftDataSpec> DATA_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSpec").getter(CreateDataSourceFromRedshiftRequest.getter(CreateDataSourceFromRedshiftRequest::dataSpec)).setter(CreateDataSourceFromRedshiftRequest.setter(Builder::dataSpec)).constructor(RedshiftDataSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSpec").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CreateDataSourceFromRedshiftRequest.getter(CreateDataSourceFromRedshiftRequest::roleARN)).setter(CreateDataSourceFromRedshiftRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<Boolean> COMPUTE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ComputeStatistics").getter(CreateDataSourceFromRedshiftRequest.getter(CreateDataSourceFromRedshiftRequest::computeStatistics)).setter(CreateDataSourceFromRedshiftRequest.setter(Builder::computeStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, DATA_SOURCE_NAME_FIELD, DATA_SPEC_FIELD, ROLE_ARN_FIELD, COMPUTE_STATISTICS_FIELD));
    private final String dataSourceId;
    private final String dataSourceName;
    private final RedshiftDataSpec dataSpec;
    private final String roleARN;
    private final Boolean computeStatistics;

    private CreateDataSourceFromRedshiftRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public RedshiftDataSpec dataSpec() {
        return this.dataSpec;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Boolean computeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatistics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRedshiftRequest)) {
            return false;
        }
        CreateDataSourceFromRedshiftRequest other = (CreateDataSourceFromRedshiftRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.dataSpec(), other.dataSpec()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.computeStatistics(), other.computeStatistics());
    }

    public String toString() {
        return ToString.builder((String)"CreateDataSourceFromRedshiftRequest").add("DataSourceId", (Object)this.dataSourceId()).add("DataSourceName", (Object)this.dataSourceName()).add("DataSpec", (Object)this.dataSpec()).add("RoleARN", (Object)this.roleARN()).add("ComputeStatistics", (Object)this.computeStatistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "DataSpec": {
                return Optional.ofNullable(clazz.cast(this.dataSpec()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ComputeStatistics": {
                return Optional.ofNullable(clazz.cast(this.computeStatistics()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromRedshiftRequest, T> g) {
        return obj -> g.apply((CreateDataSourceFromRedshiftRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private RedshiftDataSpec dataSpec;
        private String roleARN;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRedshiftRequest model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
            this.dataSpec(model.dataSpec);
            this.roleARN(model.roleARN);
            this.computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final RedshiftDataSpec.Builder getDataSpec() {
            return this.dataSpec != null ? this.dataSpec.toBuilder() : null;
        }

        @Override
        public final Builder dataSpec(RedshiftDataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(RedshiftDataSpec.BuilderImpl dataSpec) {
            this.dataSpec = dataSpec != null ? dataSpec.build() : null;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromRedshiftRequest build() {
            return new CreateDataSourceFromRedshiftRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceFromRedshiftRequest> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder dataSpec(RedshiftDataSpec var1);

        default public Builder dataSpec(Consumer<RedshiftDataSpec.Builder> dataSpec) {
            return this.dataSpec((RedshiftDataSpec)((RedshiftDataSpec.Builder)RedshiftDataSpec.builder().applyMutation(dataSpec)).build());
        }

        public Builder roleARN(String var1);

        public Builder computeStatistics(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

