/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceFromS3Response
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, CreateDataSourceFromS3Response> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDataSourceFromS3Response.getter(CreateDataSourceFromS3Response::dataSourceId)).setter(CreateDataSourceFromS3Response.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD));
    private final String dataSourceId;

    private CreateDataSourceFromS3Response(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromS3Response)) {
            return false;
        }
        CreateDataSourceFromS3Response other = (CreateDataSourceFromS3Response)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId());
    }

    public String toString() {
        return ToString.builder((String)"CreateDataSourceFromS3Response").add("DataSourceId", (Object)this.dataSourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceFromS3Response, T> g) {
        return obj -> g.apply((CreateDataSourceFromS3Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String dataSourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromS3Response model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public CreateDataSourceFromS3Response build() {
            return new CreateDataSourceFromS3Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceFromS3Response> {
        public Builder dataSourceId(String var1);
    }
}

