/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EntityStatus {
    PENDING("PENDING"),
    INPROGRESS("INPROGRESS"),
    FAILED("FAILED"),
    COMPLETED("COMPLETED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EntityStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EntityStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityStatus> knownValues() {
        return Stream.of(EntityStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

