/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDatabaseCredentialsUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDatabaseUnmarshaller;

public class RedshiftDataSpecUnmarshaller
implements Unmarshaller<RedshiftDataSpec, JsonUnmarshallerContext> {
    private static final RedshiftDataSpecUnmarshaller INSTANCE = new RedshiftDataSpecUnmarshaller();

    public RedshiftDataSpec unmarshall(JsonUnmarshallerContext context) throws Exception {
        RedshiftDataSpec.Builder redshiftDataSpecBuilder = RedshiftDataSpec.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DatabaseInformation", targetDepth)) {
                    context.nextToken();
                    redshiftDataSpecBuilder.databaseInformation(RedshiftDatabaseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SelectSqlQuery", targetDepth)) {
                    context.nextToken();
                    redshiftDataSpecBuilder.selectSqlQuery((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DatabaseCredentials", targetDepth)) {
                    context.nextToken();
                    redshiftDataSpecBuilder.databaseCredentials(RedshiftDatabaseCredentialsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("S3StagingLocation", targetDepth)) {
                    context.nextToken();
                    redshiftDataSpecBuilder.s3StagingLocation((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataRearrangement", targetDepth)) {
                    context.nextToken();
                    redshiftDataSpecBuilder.dataRearrangement((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchema", targetDepth)) {
                    context.nextToken();
                    redshiftDataSpecBuilder.dataSchema((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchemaUri", targetDepth)) {
                    context.nextToken();
                    redshiftDataSpecBuilder.dataSchemaUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RedshiftDataSpec)redshiftDataSpecBuilder.build();
    }

    public static RedshiftDataSpecUnmarshaller getInstance() {
        return INSTANCE;
    }
}

