/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.BatchPrediction;

@SdkInternalApi
public class BatchPredictionMarshaller {
    private static final MarshallingInfo<String> BATCHPREDICTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchPredictionId").build();
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").build();
    private static final MarshallingInfo<String> BATCHPREDICTIONDATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchPredictionDataSourceId").build();
    private static final MarshallingInfo<String> INPUTDATALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataLocationS3").build();
    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> OUTPUTURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUri").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").build();
    private static final MarshallingInfo<Instant> FINISHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").build();
    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").build();
    private static final MarshallingInfo<Long> TOTALRECORDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalRecordCount").build();
    private static final MarshallingInfo<Long> INVALIDRECORDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvalidRecordCount").build();
    private static final BatchPredictionMarshaller INSTANCE = new BatchPredictionMarshaller();

    public static BatchPredictionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchPrediction batchPrediction, ProtocolMarshaller protocolMarshaller) {
        if (batchPrediction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)batchPrediction.batchPredictionId(), BATCHPREDICTIONID_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.batchPredictionDataSourceId(), BATCHPREDICTIONDATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.inputDataLocationS3(), INPUTDATALOCATIONS3_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.createdByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.outputUri(), OUTPUTURI_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.computeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.finishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.totalRecordCount(), TOTALRECORDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)batchPrediction.invalidRecordCount(), INVALIDRECORDCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

