/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.MLModel;

public final class DescribeMLModelsPaginator
implements SdkIterable<DescribeMLModelsResponse> {
    private final MachineLearningClient client;
    private final DescribeMLModelsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeMLModelsPaginator(MachineLearningClient client, DescribeMLModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMLModelsResponseFetcher();
    }

    public Iterator<DescribeMLModelsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<MLModel> results() {
        Function<DescribeMLModelsResponse, Iterator> getIterator = response -> response != null ? response.results().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeMLModelsResponseFetcher
    implements NextPageFetcher<DescribeMLModelsResponse> {
        private DescribeMLModelsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMLModelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeMLModelsResponse nextPage(DescribeMLModelsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMLModelsPaginator.this.client.describeMLModels(DescribeMLModelsPaginator.this.firstRequest);
            }
            return DescribeMLModelsPaginator.this.client.describeMLModels((DescribeMLModelsRequest)((Object)DescribeMLModelsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

