/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RDSDataSpec;

@SdkInternalApi
public class RDSDataSpecMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATABASEINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseInformation").build();
    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").build();
    private static final MarshallingInfo<StructuredPojo> DATABASECREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseCredentials").build();
    private static final MarshallingInfo<String> S3STAGINGLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3StagingLocation").build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").build();
    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").build();
    private static final MarshallingInfo<String> DATASCHEMAURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaUri").build();
    private static final MarshallingInfo<String> RESOURCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceRole").build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").build();
    private static final RDSDataSpecMarshaller INSTANCE = new RDSDataSpecMarshaller();

    public static RDSDataSpecMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSDataSpec rdsDataSpec, ProtocolMarshaller protocolMarshaller) {
        if (rdsDataSpec == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rdsDataSpec.databaseInformation(), DATABASEINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.selectSqlQuery(), SELECTSQLQUERY_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.databaseCredentials(), DATABASECREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.s3StagingLocation(), S3STAGINGLOCATION_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.dataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.dataSchemaUri(), DATASCHEMAURI_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.resourceRole(), RESOURCEROLE_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)rdsDataSpec.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(rdsDataSpec.securityGroupIds(), SECURITYGROUPIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

