/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.S3DataSpecMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3DataSpec
implements StructuredPojo,
ToCopyableBuilder<Builder, S3DataSpec> {
    private final String dataLocationS3;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaLocationS3;

    private S3DataSpec(BuilderImpl builder) {
        this.dataLocationS3 = builder.dataLocationS3;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaLocationS3 = builder.dataSchemaLocationS3;
    }

    public String dataLocationS3() {
        return this.dataLocationS3;
    }

    public String dataRearrangement() {
        return this.dataRearrangement;
    }

    public String dataSchema() {
        return this.dataSchema;
    }

    public String dataSchemaLocationS3() {
        return this.dataSchemaLocationS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRearrangement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchemaLocationS3());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSpec)) {
            return false;
        }
        S3DataSpec other = (S3DataSpec)obj;
        return Objects.equals(this.dataLocationS3(), other.dataLocationS3()) && Objects.equals(this.dataRearrangement(), other.dataRearrangement()) && Objects.equals(this.dataSchema(), other.dataSchema()) && Objects.equals(this.dataSchemaLocationS3(), other.dataSchemaLocationS3());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataLocationS3() != null) {
            sb.append("DataLocationS3: ").append(this.dataLocationS3()).append(",");
        }
        if (this.dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(this.dataRearrangement()).append(",");
        }
        if (this.dataSchema() != null) {
            sb.append("DataSchema: ").append(this.dataSchema()).append(",");
        }
        if (this.dataSchemaLocationS3() != null) {
            sb.append("DataSchemaLocationS3: ").append(this.dataSchemaLocationS3()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataLocationS3": {
                return Optional.of(clazz.cast(this.dataLocationS3()));
            }
            case "DataRearrangement": {
                return Optional.of(clazz.cast(this.dataRearrangement()));
            }
            case "DataSchema": {
                return Optional.of(clazz.cast(this.dataSchema()));
            }
            case "DataSchemaLocationS3": {
                return Optional.of(clazz.cast(this.dataSchemaLocationS3()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataLocationS3;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaLocationS3;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataSpec model) {
            this.dataLocationS3(model.dataLocationS3);
            this.dataRearrangement(model.dataRearrangement);
            this.dataSchema(model.dataSchema);
            this.dataSchemaLocationS3(model.dataSchemaLocationS3);
        }

        public final String getDataLocationS3() {
            return this.dataLocationS3;
        }

        @Override
        public final Builder dataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
            return this;
        }

        public final void setDataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        public final String getDataSchemaLocationS3() {
            return this.dataSchemaLocationS3;
        }

        @Override
        public final Builder dataSchemaLocationS3(String dataSchemaLocationS3) {
            this.dataSchemaLocationS3 = dataSchemaLocationS3;
            return this;
        }

        public final void setDataSchemaLocationS3(String dataSchemaLocationS3) {
            this.dataSchemaLocationS3 = dataSchemaLocationS3;
        }

        public S3DataSpec build() {
            return new S3DataSpec(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3DataSpec> {
        public Builder dataLocationS3(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaLocationS3(String var1);
    }
}

