/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteMLModelRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, DeleteMLModelRequest> {
    private final String mlModelId;

    private DeleteMLModelRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMLModelRequest)) {
            return false;
        }
        DeleteMLModelRequest other = (DeleteMLModelRequest)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String mlModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMLModelRequest model) {
            this.mlModelId(model.mlModelId);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteMLModelRequest build() {
            return new DeleteMLModelRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, DeleteMLModelRequest> {
        public Builder mlModelId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

