/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;

@SdkInternalApi
public class RDSDatabaseMarshaller {
    private static final MarshallingInfo<String> INSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIdentifier").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final RDSDatabaseMarshaller INSTANCE = new RDSDatabaseMarshaller();

    public static RDSDatabaseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSDatabase rdsDatabase, ProtocolMarshaller protocolMarshaller) {
        if (rdsDatabase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rdsDatabase.instanceIdentifier(), INSTANCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)rdsDatabase.databaseName(), DATABASENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

