/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.EDPSecurityGroupIdsCopier;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabaseCredentials;
import software.amazon.awssdk.services.machinelearning.transform.RDSDataSpecMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RDSDataSpec
implements StructuredPojo,
ToCopyableBuilder<Builder, RDSDataSpec> {
    private final RDSDatabase databaseInformation;
    private final String selectSqlQuery;
    private final RDSDatabaseCredentials databaseCredentials;
    private final String s3StagingLocation;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaUri;
    private final String resourceRole;
    private final String serviceRole;
    private final String subnetId;
    private final List<String> securityGroupIds;

    private RDSDataSpec(BuilderImpl builder) {
        this.databaseInformation = builder.databaseInformation;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.databaseCredentials = builder.databaseCredentials;
        this.s3StagingLocation = builder.s3StagingLocation;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaUri = builder.dataSchemaUri;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.subnetId = builder.subnetId;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public RDSDatabase databaseInformation() {
        return this.databaseInformation;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public RDSDatabaseCredentials databaseCredentials() {
        return this.databaseCredentials;
    }

    public String s3StagingLocation() {
        return this.s3StagingLocation;
    }

    public String dataRearrangement() {
        return this.dataRearrangement;
    }

    public String dataSchema() {
        return this.dataSchema;
    }

    public String dataSchemaUri() {
        return this.dataSchemaUri;
    }

    public String resourceRole() {
        return this.resourceRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StagingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRearrangement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchemaUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDataSpec)) {
            return false;
        }
        RDSDataSpec other = (RDSDataSpec)obj;
        return Objects.equals(this.databaseInformation(), other.databaseInformation()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery()) && Objects.equals(this.databaseCredentials(), other.databaseCredentials()) && Objects.equals(this.s3StagingLocation(), other.s3StagingLocation()) && Objects.equals(this.dataRearrangement(), other.dataRearrangement()) && Objects.equals(this.dataSchema(), other.dataSchema()) && Objects.equals(this.dataSchemaUri(), other.dataSchemaUri()) && Objects.equals(this.resourceRole(), other.resourceRole()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.databaseInformation() != null) {
            sb.append("DatabaseInformation: ").append(this.databaseInformation()).append(",");
        }
        if (this.selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.selectSqlQuery()).append(",");
        }
        if (this.databaseCredentials() != null) {
            sb.append("DatabaseCredentials: ").append(this.databaseCredentials()).append(",");
        }
        if (this.s3StagingLocation() != null) {
            sb.append("S3StagingLocation: ").append(this.s3StagingLocation()).append(",");
        }
        if (this.dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(this.dataRearrangement()).append(",");
        }
        if (this.dataSchema() != null) {
            sb.append("DataSchema: ").append(this.dataSchema()).append(",");
        }
        if (this.dataSchemaUri() != null) {
            sb.append("DataSchemaUri: ").append(this.dataSchemaUri()).append(",");
        }
        if (this.resourceRole() != null) {
            sb.append("ResourceRole: ").append(this.resourceRole()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseInformation": {
                return Optional.of(clazz.cast(this.databaseInformation()));
            }
            case "SelectSqlQuery": {
                return Optional.of(clazz.cast(this.selectSqlQuery()));
            }
            case "DatabaseCredentials": {
                return Optional.of(clazz.cast(this.databaseCredentials()));
            }
            case "S3StagingLocation": {
                return Optional.of(clazz.cast(this.s3StagingLocation()));
            }
            case "DataRearrangement": {
                return Optional.of(clazz.cast(this.dataRearrangement()));
            }
            case "DataSchema": {
                return Optional.of(clazz.cast(this.dataSchema()));
            }
            case "DataSchemaUri": {
                return Optional.of(clazz.cast(this.dataSchemaUri()));
            }
            case "ResourceRole": {
                return Optional.of(clazz.cast(this.resourceRole()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDataSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RDSDatabase databaseInformation;
        private String selectSqlQuery;
        private RDSDatabaseCredentials databaseCredentials;
        private String s3StagingLocation;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaUri;
        private String resourceRole;
        private String serviceRole;
        private String subnetId;
        private List<String> securityGroupIds;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDataSpec model) {
            this.databaseInformation(model.databaseInformation);
            this.selectSqlQuery(model.selectSqlQuery);
            this.databaseCredentials(model.databaseCredentials);
            this.s3StagingLocation(model.s3StagingLocation);
            this.dataRearrangement(model.dataRearrangement);
            this.dataSchema(model.dataSchema);
            this.dataSchemaUri(model.dataSchemaUri);
            this.resourceRole(model.resourceRole);
            this.serviceRole(model.serviceRole);
            this.subnetId(model.subnetId);
            this.securityGroupIds(model.securityGroupIds);
        }

        public final RDSDatabase.Builder getDatabaseInformation() {
            return this.databaseInformation != null ? this.databaseInformation.toBuilder() : null;
        }

        @Override
        public final Builder databaseInformation(RDSDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
            return this;
        }

        public final void setDatabaseInformation(RDSDatabase.BuilderImpl databaseInformation) {
            this.databaseInformation = databaseInformation != null ? databaseInformation.build() : null;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final RDSDatabaseCredentials.Builder getDatabaseCredentials() {
            return this.databaseCredentials != null ? this.databaseCredentials.toBuilder() : null;
        }

        @Override
        public final Builder databaseCredentials(RDSDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
            return this;
        }

        public final void setDatabaseCredentials(RDSDatabaseCredentials.BuilderImpl databaseCredentials) {
            this.databaseCredentials = databaseCredentials != null ? databaseCredentials.build() : null;
        }

        public final String getS3StagingLocation() {
            return this.s3StagingLocation;
        }

        @Override
        public final Builder s3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
            return this;
        }

        public final void setS3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        public final String getDataSchemaUri() {
            return this.dataSchemaUri;
        }

        @Override
        public final Builder dataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
            return this;
        }

        public final void setDataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = EDPSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = EDPSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public RDSDataSpec build() {
            return new RDSDataSpec(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RDSDataSpec> {
        public Builder databaseInformation(RDSDatabase var1);

        default public Builder databaseInformation(Consumer<RDSDatabase.Builder> databaseInformation) {
            return this.databaseInformation((RDSDatabase)((RDSDatabase.Builder)RDSDatabase.builder().apply(databaseInformation)).build());
        }

        public Builder selectSqlQuery(String var1);

        public Builder databaseCredentials(RDSDatabaseCredentials var1);

        default public Builder databaseCredentials(Consumer<RDSDatabaseCredentials.Builder> databaseCredentials) {
            return this.databaseCredentials((RDSDatabaseCredentials)((RDSDatabaseCredentials.Builder)RDSDatabaseCredentials.builder().apply(databaseCredentials)).build());
        }

        public Builder s3StagingLocation(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaUri(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceRole(String var1);

        public Builder subnetId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

