/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.services.machinelearning.model.DataSourcesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDataSourcesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDataSourcesResponse> {
    private final List<DataSource> results;
    private final String nextToken;

    private DescribeDataSourcesResponse(BuilderImpl builder) {
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    public List<DataSource> results() {
        return this.results;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSourcesResponse)) {
            return false;
        }
        DescribeDataSourcesResponse other = (DescribeDataSourcesResponse)((Object)obj);
        return Objects.equals(this.results(), other.results()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.results() != null) {
            sb.append("Results: ").append(this.results()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.of(clazz.cast(this.results()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSource> results;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSourcesResponse model) {
            this.results(model.results);
            this.nextToken(model.nextToken);
        }

        public final Collection<DataSource.Builder> getResults() {
            return this.results != null ? (Collection)this.results.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<DataSource> results) {
            this.results = DataSourcesCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(DataSource ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<DataSource.BuilderImpl> results) {
            this.results = DataSourcesCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeDataSourcesResponse build() {
            return new DescribeDataSourcesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDataSourcesResponse> {
        public Builder results(Collection<DataSource> var1);

        public Builder results(DataSource ... var1);

        public Builder nextToken(String var1);
    }
}

