/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.machinelearning.model.DetailsAttributes;
import software.amazon.awssdk.services.machinelearning.model.DetailsMapCopier;
import software.amazon.awssdk.services.machinelearning.model.ScoreValuePerLabelMapCopier;
import software.amazon.awssdk.services.machinelearning.transform.PredictionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Prediction
implements StructuredPojo,
ToCopyableBuilder<Builder, Prediction> {
    private final String predictedLabel;
    private final Float predictedValue;
    private final Map<String, Float> predictedScores;
    private final Map<String, String> details;

    private Prediction(BuilderImpl builder) {
        this.predictedLabel = builder.predictedLabel;
        this.predictedValue = builder.predictedValue;
        this.predictedScores = builder.predictedScores;
        this.details = builder.details;
    }

    public String predictedLabel() {
        return this.predictedLabel;
    }

    public Float predictedValue() {
        return this.predictedValue;
    }

    public Map<String, Float> predictedScores() {
        return this.predictedScores;
    }

    public Map<DetailsAttributes, String> details() {
        return TypeConverter.convert(this.details, DetailsAttributes::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)DetailsAttributes.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> detailsStrings() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.predictedLabel() == null ? 0 : this.predictedLabel().hashCode());
        hashCode = 31 * hashCode + (this.predictedValue() == null ? 0 : this.predictedValue().hashCode());
        hashCode = 31 * hashCode + (this.predictedScores() == null ? 0 : this.predictedScores().hashCode());
        hashCode = 31 * hashCode + (this.detailsStrings() == null ? 0 : this.detailsStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prediction)) {
            return false;
        }
        Prediction other = (Prediction)obj;
        if (other.predictedLabel() == null ^ this.predictedLabel() == null) {
            return false;
        }
        if (other.predictedLabel() != null && !other.predictedLabel().equals(this.predictedLabel())) {
            return false;
        }
        if (other.predictedValue() == null ^ this.predictedValue() == null) {
            return false;
        }
        if (other.predictedValue() != null && !other.predictedValue().equals(this.predictedValue())) {
            return false;
        }
        if (other.predictedScores() == null ^ this.predictedScores() == null) {
            return false;
        }
        if (other.predictedScores() != null && !other.predictedScores().equals(this.predictedScores())) {
            return false;
        }
        if (other.detailsStrings() == null ^ this.detailsStrings() == null) {
            return false;
        }
        return other.detailsStrings() == null || other.detailsStrings().equals(this.detailsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.predictedLabel() != null) {
            sb.append("PredictedLabel: ").append(this.predictedLabel()).append(",");
        }
        if (this.predictedValue() != null) {
            sb.append("PredictedValue: ").append(this.predictedValue()).append(",");
        }
        if (this.predictedScores() != null) {
            sb.append("PredictedScores: ").append(this.predictedScores()).append(",");
        }
        if (this.detailsStrings() != null) {
            sb.append("Details: ").append(this.detailsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "predictedLabel": {
                return Optional.of(clazz.cast(this.predictedLabel()));
            }
            case "predictedValue": {
                return Optional.of(clazz.cast(this.predictedValue()));
            }
            case "predictedScores": {
                return Optional.of(clazz.cast(this.predictedScores()));
            }
            case "details": {
                return Optional.of(clazz.cast(this.detailsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredictionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String predictedLabel;
        private Float predictedValue;
        private Map<String, Float> predictedScores;
        private Map<String, String> details;

        private BuilderImpl() {
        }

        private BuilderImpl(Prediction model) {
            this.predictedLabel(model.predictedLabel);
            this.predictedValue(model.predictedValue);
            this.predictedScores(model.predictedScores);
            this.details(model.details);
        }

        public final String getPredictedLabel() {
            return this.predictedLabel;
        }

        @Override
        public final Builder predictedLabel(String predictedLabel) {
            this.predictedLabel = predictedLabel;
            return this;
        }

        public final void setPredictedLabel(String predictedLabel) {
            this.predictedLabel = predictedLabel;
        }

        public final Float getPredictedValue() {
            return this.predictedValue;
        }

        @Override
        public final Builder predictedValue(Float predictedValue) {
            this.predictedValue = predictedValue;
            return this;
        }

        public final void setPredictedValue(Float predictedValue) {
            this.predictedValue = predictedValue;
        }

        public final Map<String, Float> getPredictedScores() {
            return this.predictedScores;
        }

        @Override
        public final Builder predictedScores(Map<String, Float> predictedScores) {
            this.predictedScores = ScoreValuePerLabelMapCopier.copy(predictedScores);
            return this;
        }

        public final void setPredictedScores(Map<String, Float> predictedScores) {
            this.predictedScores = ScoreValuePerLabelMapCopier.copy(predictedScores);
        }

        public final Map<String, String> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Map<String, String> details) {
            this.details = DetailsMapCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, String> details) {
            this.details = DetailsMapCopier.copy(details);
        }

        public Prediction build() {
            return new Prediction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Prediction> {
        public Builder predictedLabel(String var1);

        public Builder predictedValue(Float var1);

        public Builder predictedScores(Map<String, Float> var1);

        public Builder details(Map<String, String> var1);
    }
}

