/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.machinelearning.model.Tag;
import software.amazon.awssdk.services.machinelearning.model.TagListCopier;
import software.amazon.awssdk.services.machinelearning.model.TaggableResourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final String resourceId;
    private final String resourceType;
    private final List<Tag> tags;

    private DescribeTagsResponse(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceTypeString() == null ? 0 : this.resourceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.resourceTypeString() == null ^ this.resourceTypeString() == null) {
            return false;
        }
        if (other.resourceTypeString() != null && !other.resourceTypeString().equals(this.resourceTypeString())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TaggableResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

