/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.machinelearning.model.MLModelType;
import software.amazon.awssdk.services.machinelearning.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateMLModelRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateMLModelRequest> {
    private final String mlModelId;
    private final String mlModelName;
    private final String mlModelType;
    private final Map<String, String> parameters;
    private final String trainingDataSourceId;
    private final String recipe;
    private final String recipeUri;

    private CreateMLModelRequest(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.mlModelType = builder.mlModelType;
        this.parameters = builder.parameters;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.recipe = builder.recipe;
        this.recipeUri = builder.recipeUri;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String mlModelName() {
        return this.mlModelName;
    }

    public MLModelType mlModelType() {
        return MLModelType.fromValue(this.mlModelType);
    }

    public String mlModelTypeString() {
        return this.mlModelType;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String trainingDataSourceId() {
        return this.trainingDataSourceId;
    }

    public String recipe() {
        return this.recipe;
    }

    public String recipeUri() {
        return this.recipeUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mlModelId() == null ? 0 : this.mlModelId().hashCode());
        hashCode = 31 * hashCode + (this.mlModelName() == null ? 0 : this.mlModelName().hashCode());
        hashCode = 31 * hashCode + (this.mlModelTypeString() == null ? 0 : this.mlModelTypeString().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.trainingDataSourceId() == null ? 0 : this.trainingDataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.recipe() == null ? 0 : this.recipe().hashCode());
        hashCode = 31 * hashCode + (this.recipeUri() == null ? 0 : this.recipeUri().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMLModelRequest)) {
            return false;
        }
        CreateMLModelRequest other = (CreateMLModelRequest)((Object)obj);
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.mlModelName() == null ^ this.mlModelName() == null) {
            return false;
        }
        if (other.mlModelName() != null && !other.mlModelName().equals(this.mlModelName())) {
            return false;
        }
        if (other.mlModelTypeString() == null ^ this.mlModelTypeString() == null) {
            return false;
        }
        if (other.mlModelTypeString() != null && !other.mlModelTypeString().equals(this.mlModelTypeString())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.trainingDataSourceId() == null ^ this.trainingDataSourceId() == null) {
            return false;
        }
        if (other.trainingDataSourceId() != null && !other.trainingDataSourceId().equals(this.trainingDataSourceId())) {
            return false;
        }
        if (other.recipe() == null ^ this.recipe() == null) {
            return false;
        }
        if (other.recipe() != null && !other.recipe().equals(this.recipe())) {
            return false;
        }
        if (other.recipeUri() == null ^ this.recipeUri() == null) {
            return false;
        }
        return other.recipeUri() == null || other.recipeUri().equals(this.recipeUri());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.mlModelId() != null) {
            sb.append("MLModelId: ").append(this.mlModelId()).append(",");
        }
        if (this.mlModelName() != null) {
            sb.append("MLModelName: ").append(this.mlModelName()).append(",");
        }
        if (this.mlModelTypeString() != null) {
            sb.append("MLModelType: ").append(this.mlModelTypeString()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.trainingDataSourceId() != null) {
            sb.append("TrainingDataSourceId: ").append(this.trainingDataSourceId()).append(",");
        }
        if (this.recipe() != null) {
            sb.append("Recipe: ").append(this.recipe()).append(",");
        }
        if (this.recipeUri() != null) {
            sb.append("RecipeUri: ").append(this.recipeUri()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "MLModelName": {
                return Optional.of(clazz.cast(this.mlModelName()));
            }
            case "MLModelType": {
                return Optional.of(clazz.cast(this.mlModelTypeString()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "TrainingDataSourceId": {
                return Optional.of(clazz.cast(this.trainingDataSourceId()));
            }
            case "Recipe": {
                return Optional.of(clazz.cast(this.recipe()));
            }
            case "RecipeUri": {
                return Optional.of(clazz.cast(this.recipeUri()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String mlModelId;
        private String mlModelName;
        private String mlModelType;
        private Map<String, String> parameters;
        private String trainingDataSourceId;
        private String recipe;
        private String recipeUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMLModelRequest model) {
            this.mlModelId(model.mlModelId);
            this.mlModelName(model.mlModelName);
            this.mlModelType(model.mlModelType);
            this.parameters(model.parameters);
            this.trainingDataSourceId(model.trainingDataSourceId);
            this.recipe(model.recipe);
            this.recipeUri(model.recipeUri);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMLModelName() {
            return this.mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMLModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final String getMLModelType() {
            return this.mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
            return this;
        }

        public final void setMLModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
        }

        public final String getTrainingDataSourceId() {
            return this.trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getRecipe() {
            return this.recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        public final String getRecipeUri() {
            return this.recipeUri;
        }

        @Override
        public final Builder recipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
            return this;
        }

        public final void setRecipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
        }

        public CreateMLModelRequest build() {
            return new CreateMLModelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateMLModelRequest> {
        public Builder mlModelId(String var1);

        public Builder mlModelName(String var1);

        public Builder mlModelType(String var1);

        public Builder mlModelType(MLModelType var1);

        public Builder parameters(Map<String, String> var1);

        public Builder trainingDataSourceId(String var1);

        public Builder recipe(String var1);

        public Builder recipeUri(String var1);
    }
}

