/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsRequest;
import software.amazon.awssdk.services.machinelearning.waiters.BatchPredictionAvailable;
import software.amazon.awssdk.services.machinelearning.waiters.DataSourceAvailable;
import software.amazon.awssdk.services.machinelearning.waiters.DescribeBatchPredictionsFunction;
import software.amazon.awssdk.services.machinelearning.waiters.DescribeDataSourcesFunction;
import software.amazon.awssdk.services.machinelearning.waiters.DescribeEvaluationsFunction;
import software.amazon.awssdk.services.machinelearning.waiters.DescribeMLModelsFunction;
import software.amazon.awssdk.services.machinelearning.waiters.EvaluationAvailable;
import software.amazon.awssdk.services.machinelearning.waiters.MLModelAvailable;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class MachineLearningClientWaiters {
    private final MachineLearningClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public MachineLearningClientWaiters(MachineLearningClient client) {
        this.client = client;
    }

    public Waiter<DescribeBatchPredictionsRequest> batchPredictionAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeBatchPredictionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new BatchPredictionAvailable.IsCOMPLETEDMatcher(), new BatchPredictionAvailable.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeMLModelsRequest> mlModelAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeMLModelsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new MLModelAvailable.IsCOMPLETEDMatcher(), new MLModelAvailable.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDataSourcesRequest> dataSourceAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDataSourcesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DataSourceAvailable.IsCOMPLETEDMatcher(), new DataSourceAvailable.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEvaluationsRequest> evaluationAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEvaluationsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EvaluationAvailable.IsCOMPLETEDMatcher(), new EvaluationAvailable.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

