/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.machinelearning.model.RDSDataSpec;
import software.amazon.awssdk.services.machinelearning.transform.RDSDatabaseCredentialsUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.RDSDatabaseUnmarshaller;

public class RDSDataSpecUnmarshaller
implements Unmarshaller<RDSDataSpec, JsonUnmarshallerContext> {
    private static final RDSDataSpecUnmarshaller INSTANCE = new RDSDataSpecUnmarshaller();

    public RDSDataSpec unmarshall(JsonUnmarshallerContext context) throws Exception {
        RDSDataSpec.Builder rdsDataSpecBuilder = RDSDataSpec.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DatabaseInformation", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.databaseInformation(RDSDatabaseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SelectSqlQuery", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.selectSqlQuery((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DatabaseCredentials", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.databaseCredentials(RDSDatabaseCredentialsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("S3StagingLocation", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.s3StagingLocation((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataRearrangement", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.dataRearrangement((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchema", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.dataSchema((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchemaUri", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.dataSchemaUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceRole", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.resourceRole((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ServiceRole", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.serviceRole((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.subnetId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.securityGroupIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RDSDataSpec)rdsDataSpecBuilder.build();
    }

    public static RDSDataSpecUnmarshaller getInstance() {
        return INSTANCE;
    }
}

