/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;

@SdkInternalApi
public class PredictRequestModelMarshaller {
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").build();
    private static final MarshallingInfo<Map> RECORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Record").build();
    private static final MarshallingInfo<String> PREDICTENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredictEndpoint").build();
    private static final PredictRequestModelMarshaller INSTANCE = new PredictRequestModelMarshaller();

    public static PredictRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PredictRequest predictRequest, ProtocolMarshaller protocolMarshaller) {
        if (predictRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)predictRequest.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall(predictRequest.record(), RECORD_BINDING);
            protocolMarshaller.marshall((Object)predictRequest.predictEndpoint(), PREDICTENDPOINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

