/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDataSpecMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDataSpec
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftDataSpec> {
    private final RedshiftDatabase databaseInformation;
    private final String selectSqlQuery;
    private final RedshiftDatabaseCredentials databaseCredentials;
    private final String s3StagingLocation;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaUri;

    private RedshiftDataSpec(BuilderImpl builder) {
        this.databaseInformation = builder.databaseInformation;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.databaseCredentials = builder.databaseCredentials;
        this.s3StagingLocation = builder.s3StagingLocation;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaUri = builder.dataSchemaUri;
    }

    public RedshiftDatabase databaseInformation() {
        return this.databaseInformation;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public RedshiftDatabaseCredentials databaseCredentials() {
        return this.databaseCredentials;
    }

    public String s3StagingLocation() {
        return this.s3StagingLocation;
    }

    public String dataRearrangement() {
        return this.dataRearrangement;
    }

    public String dataSchema() {
        return this.dataSchema;
    }

    public String dataSchemaUri() {
        return this.dataSchemaUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.databaseInformation() == null ? 0 : this.databaseInformation().hashCode());
        hashCode = 31 * hashCode + (this.selectSqlQuery() == null ? 0 : this.selectSqlQuery().hashCode());
        hashCode = 31 * hashCode + (this.databaseCredentials() == null ? 0 : this.databaseCredentials().hashCode());
        hashCode = 31 * hashCode + (this.s3StagingLocation() == null ? 0 : this.s3StagingLocation().hashCode());
        hashCode = 31 * hashCode + (this.dataRearrangement() == null ? 0 : this.dataRearrangement().hashCode());
        hashCode = 31 * hashCode + (this.dataSchema() == null ? 0 : this.dataSchema().hashCode());
        hashCode = 31 * hashCode + (this.dataSchemaUri() == null ? 0 : this.dataSchemaUri().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataSpec)) {
            return false;
        }
        RedshiftDataSpec other = (RedshiftDataSpec)obj;
        if (other.databaseInformation() == null ^ this.databaseInformation() == null) {
            return false;
        }
        if (other.databaseInformation() != null && !other.databaseInformation().equals(this.databaseInformation())) {
            return false;
        }
        if (other.selectSqlQuery() == null ^ this.selectSqlQuery() == null) {
            return false;
        }
        if (other.selectSqlQuery() != null && !other.selectSqlQuery().equals(this.selectSqlQuery())) {
            return false;
        }
        if (other.databaseCredentials() == null ^ this.databaseCredentials() == null) {
            return false;
        }
        if (other.databaseCredentials() != null && !other.databaseCredentials().equals(this.databaseCredentials())) {
            return false;
        }
        if (other.s3StagingLocation() == null ^ this.s3StagingLocation() == null) {
            return false;
        }
        if (other.s3StagingLocation() != null && !other.s3StagingLocation().equals(this.s3StagingLocation())) {
            return false;
        }
        if (other.dataRearrangement() == null ^ this.dataRearrangement() == null) {
            return false;
        }
        if (other.dataRearrangement() != null && !other.dataRearrangement().equals(this.dataRearrangement())) {
            return false;
        }
        if (other.dataSchema() == null ^ this.dataSchema() == null) {
            return false;
        }
        if (other.dataSchema() != null && !other.dataSchema().equals(this.dataSchema())) {
            return false;
        }
        if (other.dataSchemaUri() == null ^ this.dataSchemaUri() == null) {
            return false;
        }
        return other.dataSchemaUri() == null || other.dataSchemaUri().equals(this.dataSchemaUri());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.databaseInformation() != null) {
            sb.append("DatabaseInformation: ").append(this.databaseInformation()).append(",");
        }
        if (this.selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.selectSqlQuery()).append(",");
        }
        if (this.databaseCredentials() != null) {
            sb.append("DatabaseCredentials: ").append(this.databaseCredentials()).append(",");
        }
        if (this.s3StagingLocation() != null) {
            sb.append("S3StagingLocation: ").append(this.s3StagingLocation()).append(",");
        }
        if (this.dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(this.dataRearrangement()).append(",");
        }
        if (this.dataSchema() != null) {
            sb.append("DataSchema: ").append(this.dataSchema()).append(",");
        }
        if (this.dataSchemaUri() != null) {
            sb.append("DataSchemaUri: ").append(this.dataSchemaUri()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDataSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private RedshiftDatabase databaseInformation;
        private String selectSqlQuery;
        private RedshiftDatabaseCredentials databaseCredentials;
        private String s3StagingLocation;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaUri;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataSpec model) {
            this.setDatabaseInformation(model.databaseInformation);
            this.setSelectSqlQuery(model.selectSqlQuery);
            this.setDatabaseCredentials(model.databaseCredentials);
            this.setS3StagingLocation(model.s3StagingLocation);
            this.setDataRearrangement(model.dataRearrangement);
            this.setDataSchema(model.dataSchema);
            this.setDataSchemaUri(model.dataSchemaUri);
        }

        public final RedshiftDatabase getDatabaseInformation() {
            return this.databaseInformation;
        }

        @Override
        public final Builder databaseInformation(RedshiftDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
            return this;
        }

        public final void setDatabaseInformation(RedshiftDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final RedshiftDatabaseCredentials getDatabaseCredentials() {
            return this.databaseCredentials;
        }

        @Override
        public final Builder databaseCredentials(RedshiftDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
            return this;
        }

        public final void setDatabaseCredentials(RedshiftDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
        }

        public final String getS3StagingLocation() {
            return this.s3StagingLocation;
        }

        @Override
        public final Builder s3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
            return this;
        }

        public final void setS3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        public final String getDataSchemaUri() {
            return this.dataSchemaUri;
        }

        @Override
        public final Builder dataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
            return this;
        }

        public final void setDataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
        }

        public RedshiftDataSpec build() {
            return new RedshiftDataSpec(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftDataSpec> {
        public Builder databaseInformation(RedshiftDatabase var1);

        public Builder selectSqlQuery(String var1);

        public Builder databaseCredentials(RedshiftDatabaseCredentials var1);

        public Builder s3StagingLocation(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaUri(String var1);
    }
}

