/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus;
import software.amazon.awssdk.services.machinelearning.transform.RealtimeEndpointInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RealtimeEndpointInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, RealtimeEndpointInfo> {
    private final Integer peakRequestsPerSecond;
    private final Instant createdAt;
    private final String endpointUrl;
    private final String endpointStatus;

    private RealtimeEndpointInfo(BuilderImpl builder) {
        this.peakRequestsPerSecond = builder.peakRequestsPerSecond;
        this.createdAt = builder.createdAt;
        this.endpointUrl = builder.endpointUrl;
        this.endpointStatus = builder.endpointStatus;
    }

    public Integer peakRequestsPerSecond() {
        return this.peakRequestsPerSecond;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String endpointStatus() {
        return this.endpointStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.peakRequestsPerSecond() == null ? 0 : this.peakRequestsPerSecond().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.endpointUrl() == null ? 0 : this.endpointUrl().hashCode());
        hashCode = 31 * hashCode + (this.endpointStatus() == null ? 0 : this.endpointStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeEndpointInfo)) {
            return false;
        }
        RealtimeEndpointInfo other = (RealtimeEndpointInfo)obj;
        if (other.peakRequestsPerSecond() == null ^ this.peakRequestsPerSecond() == null) {
            return false;
        }
        if (other.peakRequestsPerSecond() != null && !other.peakRequestsPerSecond().equals(this.peakRequestsPerSecond())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.endpointUrl() == null ^ this.endpointUrl() == null) {
            return false;
        }
        if (other.endpointUrl() != null && !other.endpointUrl().equals(this.endpointUrl())) {
            return false;
        }
        if (other.endpointStatus() == null ^ this.endpointStatus() == null) {
            return false;
        }
        return other.endpointStatus() == null || other.endpointStatus().equals(this.endpointStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.peakRequestsPerSecond() != null) {
            sb.append("PeakRequestsPerSecond: ").append(this.peakRequestsPerSecond()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.endpointUrl() != null) {
            sb.append("EndpointUrl: ").append(this.endpointUrl()).append(",");
        }
        if (this.endpointStatus() != null) {
            sb.append("EndpointStatus: ").append(this.endpointStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RealtimeEndpointInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer peakRequestsPerSecond;
        private Instant createdAt;
        private String endpointUrl;
        private String endpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeEndpointInfo model) {
            this.setPeakRequestsPerSecond(model.peakRequestsPerSecond);
            this.setCreatedAt(model.createdAt);
            this.setEndpointUrl(model.endpointUrl);
            this.setEndpointStatus(model.endpointStatus);
        }

        public final Integer getPeakRequestsPerSecond() {
            return this.peakRequestsPerSecond;
        }

        @Override
        public final Builder peakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
            return this;
        }

        public final void setPeakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(RealtimeEndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus.toString());
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        public RealtimeEndpointInfo build() {
            return new RealtimeEndpointInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RealtimeEndpointInfo> {
        public Builder peakRequestsPerSecond(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder endpointUrl(String var1);

        public Builder endpointStatus(String var1);

        public Builder endpointStatus(RealtimeEndpointStatus var1);
    }
}

