/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.internal;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.SdkRequest;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.interceptor.Context;
import software.amazon.awssdk.interceptor.ExecutionAttributes;
import software.amazon.awssdk.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;

public class PredictEndpointInterceptor
implements ExecutionInterceptor {
    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (originalRequest instanceof PredictRequest) {
            PredictRequest pr = (PredictRequest)originalRequest;
            if (pr.predictEndpoint() == null) {
                throw new AmazonClientException("PredictRequest.PredictEndpoint is required!");
            }
            try {
                return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).endpoint(new URI(pr.predictEndpoint())).build();
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Unable to parse PredictRequest.PredictEndpoint", (Throwable)e);
            }
        }
        return request;
    }
}

