/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.S3DataSpecMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3DataSpec
implements StructuredPojo,
ToCopyableBuilder<Builder, S3DataSpec> {
    private final String dataLocationS3;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaLocationS3;

    private S3DataSpec(BuilderImpl builder) {
        this.dataLocationS3 = builder.dataLocationS3;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaLocationS3 = builder.dataSchemaLocationS3;
    }

    public String dataLocationS3() {
        return this.dataLocationS3;
    }

    public String dataRearrangement() {
        return this.dataRearrangement;
    }

    public String dataSchema() {
        return this.dataSchema;
    }

    public String dataSchemaLocationS3() {
        return this.dataSchemaLocationS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataLocationS3() == null ? 0 : this.dataLocationS3().hashCode());
        hashCode = 31 * hashCode + (this.dataRearrangement() == null ? 0 : this.dataRearrangement().hashCode());
        hashCode = 31 * hashCode + (this.dataSchema() == null ? 0 : this.dataSchema().hashCode());
        hashCode = 31 * hashCode + (this.dataSchemaLocationS3() == null ? 0 : this.dataSchemaLocationS3().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSpec)) {
            return false;
        }
        S3DataSpec other = (S3DataSpec)obj;
        if (other.dataLocationS3() == null ^ this.dataLocationS3() == null) {
            return false;
        }
        if (other.dataLocationS3() != null && !other.dataLocationS3().equals(this.dataLocationS3())) {
            return false;
        }
        if (other.dataRearrangement() == null ^ this.dataRearrangement() == null) {
            return false;
        }
        if (other.dataRearrangement() != null && !other.dataRearrangement().equals(this.dataRearrangement())) {
            return false;
        }
        if (other.dataSchema() == null ^ this.dataSchema() == null) {
            return false;
        }
        if (other.dataSchema() != null && !other.dataSchema().equals(this.dataSchema())) {
            return false;
        }
        if (other.dataSchemaLocationS3() == null ^ this.dataSchemaLocationS3() == null) {
            return false;
        }
        return other.dataSchemaLocationS3() == null || other.dataSchemaLocationS3().equals(this.dataSchemaLocationS3());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataLocationS3() != null) {
            sb.append("DataLocationS3: ").append(this.dataLocationS3()).append(",");
        }
        if (this.dataRearrangement() != null) {
            sb.append("DataRearrangement: ").append(this.dataRearrangement()).append(",");
        }
        if (this.dataSchema() != null) {
            sb.append("DataSchema: ").append(this.dataSchema()).append(",");
        }
        if (this.dataSchemaLocationS3() != null) {
            sb.append("DataSchemaLocationS3: ").append(this.dataSchemaLocationS3()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String dataLocationS3;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaLocationS3;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataSpec model) {
            this.setDataLocationS3(model.dataLocationS3);
            this.setDataRearrangement(model.dataRearrangement);
            this.setDataSchema(model.dataSchema);
            this.setDataSchemaLocationS3(model.dataSchemaLocationS3);
        }

        public final String getDataLocationS3() {
            return this.dataLocationS3;
        }

        @Override
        public final Builder dataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
            return this;
        }

        public final void setDataLocationS3(String dataLocationS3) {
            this.dataLocationS3 = dataLocationS3;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        public final String getDataSchemaLocationS3() {
            return this.dataSchemaLocationS3;
        }

        @Override
        public final Builder dataSchemaLocationS3(String dataSchemaLocationS3) {
            this.dataSchemaLocationS3 = dataSchemaLocationS3;
            return this;
        }

        public final void setDataSchemaLocationS3(String dataSchemaLocationS3) {
            this.dataSchemaLocationS3 = dataSchemaLocationS3;
        }

        public S3DataSpec build() {
            return new S3DataSpec(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3DataSpec> {
        public Builder dataLocationS3(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaLocationS3(String var1);
    }
}

