/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.machinelearning.MachineLearningBaseClientBuilder;

@SdkInternalApi
abstract class DefaultMachineLearningBaseClientBuilder<B extends MachineLearningBaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C> {
    DefaultMachineLearningBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "machinelearning";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("software/amazon/awssdk/services/machinelearning/execution.interceptors").crc32FromCompressedDataEnabled(Boolean.valueOf(false)).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("machinelearning");
        signer.setRegionName(this.signingRegion().value());
        return new StaticSignerProvider((Signer)signer);
    }
}

