/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateDataSourceRequestMarshaller
implements Marshaller<Request<UpdateDataSourceRequest>, UpdateDataSourceRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonML_20141212.UpdateDataSource").serviceName("Amazon Machine Learning").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public UpdateDataSourceRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateDataSourceRequest> marshall(UpdateDataSourceRequest updateDataSourceRequest) {
        Validate.paramNotNull((Object)((Object)updateDataSourceRequest), (String)"updateDataSourceRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)updateDataSourceRequest);
            protocolMarshaller.startMarshalling();
            UpdateDataSourceRequestModelMarshaller.getInstance().marshall(updateDataSourceRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

