/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateMlModelRequestModelMarshaller {
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").isBinary(false).build();
    private static final MarshallingInfo<String> MLMODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelName").isBinary(false).build();
    private static final MarshallingInfo<String> MLMODELTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelType").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<String> TRAININGDATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingDataSourceId").isBinary(false).build();
    private static final MarshallingInfo<String> RECIPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Recipe").isBinary(false).build();
    private static final MarshallingInfo<String> RECIPEURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecipeUri").isBinary(false).build();
    private static final CreateMlModelRequestModelMarshaller INSTANCE = new CreateMlModelRequestModelMarshaller();

    private CreateMlModelRequestModelMarshaller() {
    }

    public static CreateMlModelRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateMlModelRequest createMlModelRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createMlModelRequest), (String)"createMlModelRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createMlModelRequest.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall((Object)createMlModelRequest.mlModelName(), MLMODELNAME_BINDING);
            protocolMarshaller.marshall((Object)createMlModelRequest.mlModelTypeAsString(), MLMODELTYPE_BINDING);
            protocolMarshaller.marshall(createMlModelRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)createMlModelRequest.trainingDataSourceId(), TRAININGDATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)createMlModelRequest.recipe(), RECIPE_BINDING);
            protocolMarshaller.marshall((Object)createMlModelRequest.recipeUri(), RECIPEURI_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

