/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.machinelearning.model.MLModelType;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateMLModelRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateMLModelRequest> {
    private final String mlModelId;
    private final String mlModelName;
    private final String mlModelType;
    private final Map<String, String> parameters;
    private final String trainingDataSourceId;
    private final String recipe;
    private final String recipeUri;

    private CreateMLModelRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.mlModelType = builder.mlModelType;
        this.parameters = builder.parameters;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.recipe = builder.recipe;
        this.recipeUri = builder.recipeUri;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String mlModelName() {
        return this.mlModelName;
    }

    public MLModelType mlModelType() {
        return MLModelType.fromValue(this.mlModelType);
    }

    public String mlModelTypeAsString() {
        return this.mlModelType;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String trainingDataSourceId() {
        return this.trainingDataSourceId;
    }

    public String recipe() {
        return this.recipe;
    }

    public String recipeUri() {
        return this.recipeUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeUri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMLModelRequest)) {
            return false;
        }
        CreateMLModelRequest other = (CreateMLModelRequest)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.mlModelName(), other.mlModelName()) && Objects.equals(this.mlModelTypeAsString(), other.mlModelTypeAsString()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.trainingDataSourceId(), other.trainingDataSourceId()) && Objects.equals(this.recipe(), other.recipe()) && Objects.equals(this.recipeUri(), other.recipeUri());
    }

    public String toString() {
        return ToString.builder((String)"CreateMLModelRequest").add("MLModelId", (Object)this.mlModelId()).add("MLModelName", (Object)this.mlModelName()).add("MLModelType", (Object)this.mlModelTypeAsString()).add("Parameters", this.parameters()).add("TrainingDataSourceId", (Object)this.trainingDataSourceId()).add("Recipe", (Object)this.recipe()).add("RecipeUri", (Object)this.recipeUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "MLModelName": {
                return Optional.of(clazz.cast(this.mlModelName()));
            }
            case "MLModelType": {
                return Optional.of(clazz.cast(this.mlModelTypeAsString()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "TrainingDataSourceId": {
                return Optional.of(clazz.cast(this.trainingDataSourceId()));
            }
            case "Recipe": {
                return Optional.of(clazz.cast(this.recipe()));
            }
            case "RecipeUri": {
                return Optional.of(clazz.cast(this.recipeUri()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String mlModelId;
        private String mlModelName;
        private String mlModelType;
        private Map<String, String> parameters;
        private String trainingDataSourceId;
        private String recipe;
        private String recipeUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMLModelRequest model) {
            super(model);
            this.mlModelId(model.mlModelId);
            this.mlModelName(model.mlModelName);
            this.mlModelType(model.mlModelType);
            this.parameters(model.parameters);
            this.trainingDataSourceId(model.trainingDataSourceId);
            this.recipe(model.recipe);
            this.recipeUri(model.recipeUri);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMLModelName() {
            return this.mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMLModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final String getMLModelType() {
            return this.mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
            return this;
        }

        public final void setMLModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TrainingParametersCopier.copy(parameters);
        }

        public final String getTrainingDataSourceId() {
            return this.trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getRecipe() {
            return this.recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        public final String getRecipeUri() {
            return this.recipeUri;
        }

        @Override
        public final Builder recipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
            return this;
        }

        public final void setRecipeUri(String recipeUri) {
            this.recipeUri = recipeUri;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateMLModelRequest build() {
            return new CreateMLModelRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, CreateMLModelRequest> {
        public Builder mlModelId(String var1);

        public Builder mlModelName(String var1);

        public Builder mlModelType(String var1);

        public Builder mlModelType(MLModelType var1);

        public Builder parameters(Map<String, String> var1);

        public Builder trainingDataSourceId(String var1);

        public Builder recipe(String var1);

        public Builder recipeUri(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

