/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.AddTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.AddTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRDSResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateMLModelResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteMLModelResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.GetMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.GetMLModelResponse;
import software.amazon.awssdk.services.machinelearning.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.machinelearning.model.InternalServerException;
import software.amazon.awssdk.services.machinelearning.model.InvalidInputException;
import software.amazon.awssdk.services.machinelearning.model.InvalidTagException;
import software.amazon.awssdk.services.machinelearning.model.LimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningException;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictResponse;
import software.amazon.awssdk.services.machinelearning.model.PredictorNotMountedException;
import software.amazon.awssdk.services.machinelearning.model.ResourceNotFoundException;
import software.amazon.awssdk.services.machinelearning.model.TagLimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateMLModelRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateMLModelResponse;
import software.amazon.awssdk.services.machinelearning.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRDSRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRDSResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRedshiftRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRedshiftResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromS3RequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromS3ResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateMLModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateRealtimeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteMLModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteRealtimeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeBatchPredictionsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeBatchPredictionsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeDataSourcesResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeEvaluationsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeMLModelsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeMLModelsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetMLModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.PredictRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.PredictResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateMLModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateMLModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.waiters.MachineLearningClientWaiters;

@SdkInternalApi
final class DefaultMachineLearningClient
implements MachineLearningClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;
    private volatile MachineLearningClientWaiters waiters;

    protected DefaultMachineLearningClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws InvalidInputException, InvalidTagException, TagLimitExceededException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AddTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateBatchPredictionResponse createBatchPrediction(CreateBatchPredictionRequest createBatchPredictionRequest) throws InvalidInputException, InternalServerException, IdempotentParameterMismatchException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateBatchPredictionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateBatchPredictionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createBatchPredictionRequest).withMarshaller((Marshaller)new CreateBatchPredictionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateDataSourceFromRDSResponse createDataSourceFromRDS(CreateDataSourceFromRDSRequest createDataSourceFromRDSRequest) throws InvalidInputException, InternalServerException, IdempotentParameterMismatchException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateDataSourceFromRDSResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateDataSourceFromRDSResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createDataSourceFromRDSRequest).withMarshaller((Marshaller)new CreateDataSourceFromRDSRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateDataSourceFromRedshiftResponse createDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) throws InvalidInputException, InternalServerException, IdempotentParameterMismatchException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateDataSourceFromRedshiftResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateDataSourceFromRedshiftResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createDataSourceFromRedshiftRequest).withMarshaller((Marshaller)new CreateDataSourceFromRedshiftRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateDataSourceFromS3Response createDataSourceFromS3(CreateDataSourceFromS3Request createDataSourceFromS3Request) throws InvalidInputException, InternalServerException, IdempotentParameterMismatchException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateDataSourceFromS3ResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateDataSourceFromS3Response)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createDataSourceFromS3Request).withMarshaller((Marshaller)new CreateDataSourceFromS3RequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateEvaluationResponse createEvaluation(CreateEvaluationRequest createEvaluationRequest) throws InvalidInputException, InternalServerException, IdempotentParameterMismatchException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateEvaluationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateEvaluationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createEvaluationRequest).withMarshaller((Marshaller)new CreateEvaluationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateMLModelResponse createMLModel(CreateMLModelRequest createMLModelRequest) throws InvalidInputException, InternalServerException, IdempotentParameterMismatchException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateMLModelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateMLModelResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createMLModelRequest).withMarshaller((Marshaller)new CreateMLModelRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateRealtimeEndpointResponse createRealtimeEndpoint(CreateRealtimeEndpointRequest createRealtimeEndpointRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateRealtimeEndpointResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateRealtimeEndpointResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createRealtimeEndpointRequest).withMarshaller((Marshaller)new CreateRealtimeEndpointRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteBatchPredictionResponse deleteBatchPrediction(DeleteBatchPredictionRequest deleteBatchPredictionRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteBatchPredictionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteBatchPredictionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteBatchPredictionRequest).withMarshaller((Marshaller)new DeleteBatchPredictionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteDataSourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteDataSourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteDataSourceRequest).withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteEvaluationResponse deleteEvaluation(DeleteEvaluationRequest deleteEvaluationRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteEvaluationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteEvaluationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteEvaluationRequest).withMarshaller((Marshaller)new DeleteEvaluationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteMLModelResponse deleteMLModel(DeleteMLModelRequest deleteMLModelRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteMLModelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteMLModelResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteMLModelRequest).withMarshaller((Marshaller)new DeleteMLModelRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteRealtimeEndpointResponse deleteRealtimeEndpoint(DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteRealtimeEndpointResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteRealtimeEndpointResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteRealtimeEndpointRequest).withMarshaller((Marshaller)new DeleteRealtimeEndpointRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws InvalidInputException, InvalidTagException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteTagsRequest).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeBatchPredictionsResponse describeBatchPredictions(DescribeBatchPredictionsRequest describeBatchPredictionsRequest) throws InvalidInputException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeBatchPredictionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeBatchPredictionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeBatchPredictionsRequest).withMarshaller((Marshaller)new DescribeBatchPredictionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeDataSourcesResponse describeDataSources(DescribeDataSourcesRequest describeDataSourcesRequest) throws InvalidInputException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeDataSourcesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeDataSourcesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeDataSourcesRequest).withMarshaller((Marshaller)new DescribeDataSourcesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeEvaluationsResponse describeEvaluations(DescribeEvaluationsRequest describeEvaluationsRequest) throws InvalidInputException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeEvaluationsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEvaluationsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeEvaluationsRequest).withMarshaller((Marshaller)new DescribeEvaluationsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeMLModelsResponse describeMLModels(DescribeMLModelsRequest describeMLModelsRequest) throws InvalidInputException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeMLModelsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeMLModelsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeMLModelsRequest).withMarshaller((Marshaller)new DescribeMLModelsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeTagsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeTagsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeTagsRequest).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetBatchPredictionResponse getBatchPrediction(GetBatchPredictionRequest getBatchPredictionRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetBatchPredictionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetBatchPredictionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getBatchPredictionRequest).withMarshaller((Marshaller)new GetBatchPredictionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetDataSourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDataSourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getDataSourceRequest).withMarshaller((Marshaller)new GetDataSourceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetEvaluationResponse getEvaluation(GetEvaluationRequest getEvaluationRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetEvaluationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetEvaluationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getEvaluationRequest).withMarshaller((Marshaller)new GetEvaluationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetMLModelResponse getMLModel(GetMLModelRequest getMLModelRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetMLModelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetMLModelResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getMLModelRequest).withMarshaller((Marshaller)new GetMLModelRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public PredictResponse predict(PredictRequest predictRequest) throws InvalidInputException, ResourceNotFoundException, LimitExceededException, InternalServerException, PredictorNotMountedException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PredictResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PredictResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)predictRequest).withMarshaller((Marshaller)new PredictRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateBatchPredictionResponse updateBatchPrediction(UpdateBatchPredictionRequest updateBatchPredictionRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateBatchPredictionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateBatchPredictionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateBatchPredictionRequest).withMarshaller((Marshaller)new UpdateBatchPredictionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateDataSourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateDataSourceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateDataSourceRequest).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateEvaluationResponse updateEvaluation(UpdateEvaluationRequest updateEvaluationRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateEvaluationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateEvaluationResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateEvaluationRequest).withMarshaller((Marshaller)new UpdateEvaluationRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateMLModelResponse updateMLModel(UpdateMLModelRequest updateMLModelRequest) throws InvalidInputException, ResourceNotFoundException, InternalServerException, SdkBaseException, SdkClientException, MachineLearningException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateMLModelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateMLModelResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateMLModelRequest).withMarshaller((Marshaller)new UpdateMLModelRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MachineLearningException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTagException").withModeledClass(InvalidTagException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatchException").withModeledClass(IdempotentParameterMismatchException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagLimitExceededException").withModeledClass(TagLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PredictorNotMountedException").withModeledClass(PredictorNotMountedException.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MachineLearningClientWaiters waiters() {
        if (this.waiters == null) {
            DefaultMachineLearningClient defaultMachineLearningClient = this;
            synchronized (defaultMachineLearningClient) {
                if (this.waiters == null) {
                    this.waiters = new MachineLearningClientWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

