/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends M2Request implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<Integer> CURRENT_APPLICATION_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("currentApplicationVersion")
            .getter(getter(UpdateApplicationRequest::currentApplicationVersion))
            .setter(setter(Builder::currentApplicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentApplicationVersion").build())
            .build();

    private static final SdkField<Definition> DEFINITION_FIELD = SdkField.<Definition> builder(MarshallingType.SDK_POJO)
            .memberName("definition").getter(getter(UpdateApplicationRequest::definition)).setter(setter(Builder::definition))
            .constructor(Definition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CURRENT_APPLICATION_VERSION_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final Integer currentApplicationVersion;

    private final Definition definition;

    private final String description;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.currentApplicationVersion = builder.currentApplicationVersion;
        this.definition = builder.definition;
        this.description = builder.description;
    }

    /**
     * <p>
     * The unique identifier of the application you want to update.
     * </p>
     * 
     * @return The unique identifier of the application you want to update.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The current version of the application to update.
     * </p>
     * 
     * @return The current version of the application to update.
     */
    public final Integer currentApplicationVersion() {
        return currentApplicationVersion;
    }

    /**
     * <p>
     * The application definition for this application. You can specify either inline JSON or an S3 bucket location.
     * </p>
     * 
     * @return The application definition for this application. You can specify either inline JSON or an S3 bucket
     *         location.
     */
    public final Definition definition() {
        return definition;
    }

    /**
     * <p>
     * The description of the application to update.
     * </p>
     * 
     * @return The description of the application to update.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(currentApplicationVersion(), other.currentApplicationVersion())
                && Objects.equals(definition(), other.definition()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ApplicationId", applicationId())
                .add("CurrentApplicationVersion", currentApplicationVersion()).add("Definition", definition())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "currentApplicationVersion":
            return Optional.ofNullable(clazz.cast(currentApplicationVersion()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("currentApplicationVersion", CURRENT_APPLICATION_VERSION_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The unique identifier of the application you want to update.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The current version of the application to update.
         * </p>
         * 
         * @param currentApplicationVersion
         *        The current version of the application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersion(Integer currentApplicationVersion);

        /**
         * <p>
         * The application definition for this application. You can specify either inline JSON or an S3 bucket location.
         * </p>
         * 
         * @param definition
         *        The application definition for this application. You can specify either inline JSON or an S3 bucket
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(Definition definition);

        /**
         * <p>
         * The application definition for this application. You can specify either inline JSON or an S3 bucket location.
         * </p>
         * This is a convenience method that creates an instance of the {@link Definition.Builder} avoiding the need to
         * create one manually via {@link Definition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Definition.Builder#build()} is called immediately and its result
         * is passed to {@link #definition(Definition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link Definition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(Definition)
         */
        default Builder definition(Consumer<Definition.Builder> definition) {
            return definition(Definition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The description of the application to update.
         * </p>
         * 
         * @param description
         *        The description of the application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String applicationId;

        private Integer currentApplicationVersion;

        private Definition definition;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            currentApplicationVersion(model.currentApplicationVersion);
            definition(model.definition);
            description(model.description);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Integer getCurrentApplicationVersion() {
            return currentApplicationVersion;
        }

        public final void setCurrentApplicationVersion(Integer currentApplicationVersion) {
            this.currentApplicationVersion = currentApplicationVersion;
        }

        @Override
        public final Builder currentApplicationVersion(Integer currentApplicationVersion) {
            this.currentApplicationVersion = currentApplicationVersion;
            return this;
        }

        public final Definition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(Definition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
