/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBatchJobExecutionsResponse extends M2Response implements
        ToCopyableBuilder<ListBatchJobExecutionsResponse.Builder, ListBatchJobExecutionsResponse> {
    private static final SdkField<List<BatchJobExecutionSummary>> BATCH_JOB_EXECUTIONS_FIELD = SdkField
            .<List<BatchJobExecutionSummary>> builder(MarshallingType.LIST)
            .memberName("batchJobExecutions")
            .getter(getter(ListBatchJobExecutionsResponse::batchJobExecutions))
            .setter(setter(Builder::batchJobExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchJobExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchJobExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBatchJobExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_JOB_EXECUTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchJobExecutionSummary> batchJobExecutions;

    private final String nextToken;

    private ListBatchJobExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.batchJobExecutions = builder.batchJobExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchJobExecutions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchJobExecutions() {
        return batchJobExecutions != null && !(batchJobExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of batch job executions for an application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchJobExecutions} method.
     * </p>
     * 
     * @return Returns a list of batch job executions for an application.
     */
    public final List<BatchJobExecutionSummary> batchJobExecutions() {
        return batchJobExecutions;
    }

    /**
     * <p>
     * A pagination token that's returned when the response doesn't contain all batch job executions.
     * </p>
     * 
     * @return A pagination token that's returned when the response doesn't contain all batch job executions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchJobExecutions() ? batchJobExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchJobExecutionsResponse)) {
            return false;
        }
        ListBatchJobExecutionsResponse other = (ListBatchJobExecutionsResponse) obj;
        return hasBatchJobExecutions() == other.hasBatchJobExecutions()
                && Objects.equals(batchJobExecutions(), other.batchJobExecutions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBatchJobExecutionsResponse")
                .add("BatchJobExecutions", hasBatchJobExecutions() ? batchJobExecutions() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchJobExecutions":
            return Optional.ofNullable(clazz.cast(batchJobExecutions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("batchJobExecutions", BATCH_JOB_EXECUTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBatchJobExecutionsResponse, T> g) {
        return obj -> g.apply((ListBatchJobExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBatchJobExecutionsResponse> {
        /**
         * <p>
         * Returns a list of batch job executions for an application.
         * </p>
         * 
         * @param batchJobExecutions
         *        Returns a list of batch job executions for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchJobExecutions(Collection<BatchJobExecutionSummary> batchJobExecutions);

        /**
         * <p>
         * Returns a list of batch job executions for an application.
         * </p>
         * 
         * @param batchJobExecutions
         *        Returns a list of batch job executions for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchJobExecutions(BatchJobExecutionSummary... batchJobExecutions);

        /**
         * <p>
         * Returns a list of batch job executions for an application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #batchJobExecutions(List<BatchJobExecutionSummary>)}.
         * 
         * @param batchJobExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.BatchJobExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchJobExecutions(java.util.Collection<BatchJobExecutionSummary>)
         */
        Builder batchJobExecutions(Consumer<BatchJobExecutionSummary.Builder>... batchJobExecutions);

        /**
         * <p>
         * A pagination token that's returned when the response doesn't contain all batch job executions.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's returned when the response doesn't contain all batch job executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private List<BatchJobExecutionSummary> batchJobExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchJobExecutionsResponse model) {
            super(model);
            batchJobExecutions(model.batchJobExecutions);
            nextToken(model.nextToken);
        }

        public final List<BatchJobExecutionSummary.Builder> getBatchJobExecutions() {
            List<BatchJobExecutionSummary.Builder> result = BatchJobExecutionSummaryListCopier
                    .copyToBuilder(this.batchJobExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchJobExecutions(Collection<BatchJobExecutionSummary.BuilderImpl> batchJobExecutions) {
            this.batchJobExecutions = BatchJobExecutionSummaryListCopier.copyFromBuilder(batchJobExecutions);
        }

        @Override
        public final Builder batchJobExecutions(Collection<BatchJobExecutionSummary> batchJobExecutions) {
            this.batchJobExecutions = BatchJobExecutionSummaryListCopier.copy(batchJobExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobExecutions(BatchJobExecutionSummary... batchJobExecutions) {
            batchJobExecutions(Arrays.asList(batchJobExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobExecutions(Consumer<BatchJobExecutionSummary.Builder>... batchJobExecutions) {
            batchJobExecutions(Stream.of(batchJobExecutions)
                    .map(c -> BatchJobExecutionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBatchJobExecutionsResponse build() {
            return new ListBatchJobExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
