/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subset of information about a specific deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentSummary.Builder, DeploymentSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(DeploymentSummary::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<Integer> APPLICATION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applicationVersion").getter(getter(DeploymentSummary::applicationVersion))
            .setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DeploymentSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(DeploymentSummary::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(DeploymentSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeploymentSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(DeploymentSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_VERSION_FIELD, CREATION_TIME_FIELD, DEPLOYMENT_ID_FIELD, ENVIRONMENT_ID_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final Integer applicationVersion;

    private final Instant creationTime;

    private final String deploymentId;

    private final String environmentId;

    private final String status;

    private final String statusReason;

    private DeploymentSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationVersion = builder.applicationVersion;
        this.creationTime = builder.creationTime;
        this.deploymentId = builder.deploymentId;
        this.environmentId = builder.environmentId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public final Integer applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * The timestamp when the deployment was created.
     * </p>
     * 
     * @return The timestamp when the deployment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The unique identifier of the deployment.
     * </p>
     * 
     * @return The unique identifier of the deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The unique identifier of the runtime environment.
     * </p>
     * 
     * @return The unique identifier of the runtime environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The current status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the deployment.
     * @see DeploymentLifecycle
     */
    public final DeploymentLifecycle status() {
        return DeploymentLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The current status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the deployment.
     * @see DeploymentLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the reported status.
     * </p>
     * 
     * @return The reason for the reported status.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentSummary)) {
            return false;
        }
        DeploymentSummary other = (DeploymentSummary) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentSummary").add("ApplicationId", applicationId())
                .add("ApplicationVersion", applicationVersion()).add("CreationTime", creationTime())
                .add("DeploymentId", deploymentId()).add("EnvironmentId", environmentId()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("applicationVersion", APPLICATION_VERSION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("deploymentId", DEPLOYMENT_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentSummary, T> g) {
        return obj -> g.apply((DeploymentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentSummary> {
        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(Integer applicationVersion);

        /**
         * <p>
         * The timestamp when the deployment was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The unique identifier of the deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique identifier of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The unique identifier of the runtime environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The current status of the deployment.
         * </p>
         * 
         * @param status
         *        The current status of the deployment.
         * @see DeploymentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the deployment.
         * </p>
         * 
         * @param status
         *        The current status of the deployment.
         * @see DeploymentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentLifecycle
         */
        Builder status(DeploymentLifecycle status);

        /**
         * <p>
         * The reason for the reported status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the reported status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private Integer applicationVersion;

        private Instant creationTime;

        private String deploymentId;

        private String environmentId;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentSummary model) {
            applicationId(model.applicationId);
            applicationVersion(model.applicationVersion);
            creationTime(model.creationTime);
            deploymentId(model.deploymentId);
            environmentId(model.environmentId);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Integer getApplicationVersion() {
            return applicationVersion;
        }

        public final void setApplicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public DeploymentSummary build() {
            return new DeploymentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
