/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.DataSetImportTask;
import software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse;

public class ListDataSetImportHistoryPublisher
implements SdkPublisher<ListDataSetImportHistoryResponse> {
    private final M2AsyncClient client;
    private final ListDataSetImportHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSetImportHistoryPublisher(M2AsyncClient client, ListDataSetImportHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSetImportHistoryPublisher(M2AsyncClient client, ListDataSetImportHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSetImportHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSetImportHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSetImportTask> dataSetImportTasks() {
        Function<ListDataSetImportHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSetImportTasks() != null) {
                return response.dataSetImportTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataSetImportHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSetImportHistoryResponseFetcher
    implements AsyncPageFetcher<ListDataSetImportHistoryResponse> {
        private ListDataSetImportHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetImportHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSetImportHistoryResponse> nextPage(ListDataSetImportHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetImportHistoryPublisher.this.client.listDataSetImportHistory(ListDataSetImportHistoryPublisher.this.firstRequest);
            }
            return ListDataSetImportHistoryPublisher.this.client.listDataSetImportHistory((ListDataSetImportHistoryRequest)((Object)ListDataSetImportHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

