/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.AlternateKey;
import software.amazon.awssdk.services.m2.model.AlternateKeyListCopier;
import software.amazon.awssdk.services.m2.model.PrimaryKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VsamDetailAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VsamDetailAttributes> {
    private static final SdkField<List<AlternateKey>> ALTERNATE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alternateKeys").getter(VsamDetailAttributes.getter(VsamDetailAttributes::alternateKeys)).setter(VsamDetailAttributes.setter(Builder::alternateKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlternateKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CACHE_AT_STARTUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cacheAtStartup").getter(VsamDetailAttributes.getter(VsamDetailAttributes::cacheAtStartup)).setter(VsamDetailAttributes.setter(Builder::cacheAtStartup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheAtStartup").build()}).build();
    private static final SdkField<Boolean> COMPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("compressed").getter(VsamDetailAttributes.getter(VsamDetailAttributes::compressed)).setter(VsamDetailAttributes.setter(Builder::compressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compressed").build()}).build();
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encoding").getter(VsamDetailAttributes.getter(VsamDetailAttributes::encoding)).setter(VsamDetailAttributes.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()}).build();
    private static final SdkField<PrimaryKey> PRIMARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryKey").getter(VsamDetailAttributes.getter(VsamDetailAttributes::primaryKey)).setter(VsamDetailAttributes.setter(Builder::primaryKey)).constructor(PrimaryKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKey").build()}).build();
    private static final SdkField<String> RECORD_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordFormat").getter(VsamDetailAttributes.getter(VsamDetailAttributes::recordFormat)).setter(VsamDetailAttributes.setter(Builder::recordFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_KEYS_FIELD, CACHE_AT_STARTUP_FIELD, COMPRESSED_FIELD, ENCODING_FIELD, PRIMARY_KEY_FIELD, RECORD_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VsamDetailAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AlternateKey> alternateKeys;
    private final Boolean cacheAtStartup;
    private final Boolean compressed;
    private final String encoding;
    private final PrimaryKey primaryKey;
    private final String recordFormat;

    private VsamDetailAttributes(BuilderImpl builder) {
        this.alternateKeys = builder.alternateKeys;
        this.cacheAtStartup = builder.cacheAtStartup;
        this.compressed = builder.compressed;
        this.encoding = builder.encoding;
        this.primaryKey = builder.primaryKey;
        this.recordFormat = builder.recordFormat;
    }

    public final boolean hasAlternateKeys() {
        return this.alternateKeys != null && !(this.alternateKeys instanceof SdkAutoConstructList);
    }

    public final List<AlternateKey> alternateKeys() {
        return this.alternateKeys;
    }

    public final Boolean cacheAtStartup() {
        return this.cacheAtStartup;
    }

    public final Boolean compressed() {
        return this.compressed;
    }

    public final String encoding() {
        return this.encoding;
    }

    public final PrimaryKey primaryKey() {
        return this.primaryKey;
    }

    public final String recordFormat() {
        return this.recordFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternateKeys() ? this.alternateKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAtStartup());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VsamDetailAttributes)) {
            return false;
        }
        VsamDetailAttributes other = (VsamDetailAttributes)obj;
        return this.hasAlternateKeys() == other.hasAlternateKeys() && Objects.equals(this.alternateKeys(), other.alternateKeys()) && Objects.equals(this.cacheAtStartup(), other.cacheAtStartup()) && Objects.equals(this.compressed(), other.compressed()) && Objects.equals(this.encoding(), other.encoding()) && Objects.equals(this.primaryKey(), other.primaryKey()) && Objects.equals(this.recordFormat(), other.recordFormat());
    }

    public final String toString() {
        return ToString.builder((String)"VsamDetailAttributes").add("AlternateKeys", this.hasAlternateKeys() ? this.alternateKeys() : null).add("CacheAtStartup", (Object)this.cacheAtStartup()).add("Compressed", (Object)this.compressed()).add("Encoding", (Object)this.encoding()).add("PrimaryKey", (Object)this.primaryKey()).add("RecordFormat", (Object)this.recordFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alternateKeys": {
                return Optional.ofNullable(clazz.cast(this.alternateKeys()));
            }
            case "cacheAtStartup": {
                return Optional.ofNullable(clazz.cast(this.cacheAtStartup()));
            }
            case "compressed": {
                return Optional.ofNullable(clazz.cast(this.compressed()));
            }
            case "encoding": {
                return Optional.ofNullable(clazz.cast(this.encoding()));
            }
            case "primaryKey": {
                return Optional.ofNullable(clazz.cast(this.primaryKey()));
            }
            case "recordFormat": {
                return Optional.ofNullable(clazz.cast(this.recordFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alternateKeys", ALTERNATE_KEYS_FIELD);
        map.put("cacheAtStartup", CACHE_AT_STARTUP_FIELD);
        map.put("compressed", COMPRESSED_FIELD);
        map.put("encoding", ENCODING_FIELD);
        map.put("primaryKey", PRIMARY_KEY_FIELD);
        map.put("recordFormat", RECORD_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VsamDetailAttributes, T> g) {
        return obj -> g.apply((VsamDetailAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AlternateKey> alternateKeys = DefaultSdkAutoConstructList.getInstance();
        private Boolean cacheAtStartup;
        private Boolean compressed;
        private String encoding;
        private PrimaryKey primaryKey;
        private String recordFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(VsamDetailAttributes model) {
            this.alternateKeys(model.alternateKeys);
            this.cacheAtStartup(model.cacheAtStartup);
            this.compressed(model.compressed);
            this.encoding(model.encoding);
            this.primaryKey(model.primaryKey);
            this.recordFormat(model.recordFormat);
        }

        public final List<AlternateKey.Builder> getAlternateKeys() {
            List<AlternateKey.Builder> result = AlternateKeyListCopier.copyToBuilder(this.alternateKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternateKeys(Collection<AlternateKey.BuilderImpl> alternateKeys) {
            this.alternateKeys = AlternateKeyListCopier.copyFromBuilder(alternateKeys);
        }

        @Override
        public final Builder alternateKeys(Collection<AlternateKey> alternateKeys) {
            this.alternateKeys = AlternateKeyListCopier.copy(alternateKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateKeys(AlternateKey ... alternateKeys) {
            this.alternateKeys(Arrays.asList(alternateKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateKeys(Consumer<AlternateKey.Builder> ... alternateKeys) {
            this.alternateKeys(Stream.of(alternateKeys).map(c -> (AlternateKey)((AlternateKey.Builder)AlternateKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCacheAtStartup() {
            return this.cacheAtStartup;
        }

        public final void setCacheAtStartup(Boolean cacheAtStartup) {
            this.cacheAtStartup = cacheAtStartup;
        }

        @Override
        public final Builder cacheAtStartup(Boolean cacheAtStartup) {
            this.cacheAtStartup = cacheAtStartup;
            return this;
        }

        public final Boolean getCompressed() {
            return this.compressed;
        }

        public final void setCompressed(Boolean compressed) {
            this.compressed = compressed;
        }

        @Override
        public final Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final PrimaryKey.Builder getPrimaryKey() {
            return this.primaryKey != null ? this.primaryKey.toBuilder() : null;
        }

        public final void setPrimaryKey(PrimaryKey.BuilderImpl primaryKey) {
            this.primaryKey = primaryKey != null ? primaryKey.build() : null;
        }

        @Override
        public final Builder primaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public final String getRecordFormat() {
            return this.recordFormat;
        }

        public final void setRecordFormat(String recordFormat) {
            this.recordFormat = recordFormat;
        }

        @Override
        public final Builder recordFormat(String recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        public VsamDetailAttributes build() {
            return new VsamDetailAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VsamDetailAttributes> {
        public Builder alternateKeys(Collection<AlternateKey> var1);

        public Builder alternateKeys(AlternateKey ... var1);

        public Builder alternateKeys(Consumer<AlternateKey.Builder> ... var1);

        public Builder cacheAtStartup(Boolean var1);

        public Builder compressed(Boolean var1);

        public Builder encoding(String var1);

        public Builder primaryKey(PrimaryKey var1);

        default public Builder primaryKey(Consumer<PrimaryKey.Builder> primaryKey) {
            return this.primaryKey((PrimaryKey)((PrimaryKey.Builder)PrimaryKey.builder().applyMutation(primaryKey)).build());
        }

        public Builder recordFormat(String var1);
    }
}

